/***************************************************************************
                          childdisplay.cpp  -  description
                             -------------------
    begin                : Sat Jan 29 2000
    copyright            : (C) 2000 by Edson Pereira
    email                : edson_pereira@harvard.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qpainter.h>
#include <qpixmap.h>

#include "childdisplay.h"

ChildDisplay::ChildDisplay( QWidget *parent=0, const char *name=0 )
                            : QWidget( parent, name )
{
    setBackgroundColor( QColor( 50, 60, 60 ) );
}

ChildDisplay::~ChildDisplay(){
}

void ChildDisplay::setFontColor( int colorR, int colorG, int colorB )
{
	pen.setColor( QColor( colorR, colorG, colorB ) );
}

/** Handles paint events */
void ChildDisplay::paintEvent( QPaintEvent * e ){
	QRect    r = e->rect();
	QPixmap  pix( r.size());
	QPainter p;
	QPainter tmp;

	pix.fill( this, r.topLeft() );
	
    QFont font( "Fixed", 10, 50, 0 );
    font.setFixedPitch( TRUE );
    font.setStyleHint( (QFont::StyleHint)0 );
    font.setCharSet( (QFont::CharSet)0 );

	tmp.begin( &pix );
	tmp.setPen( pen );
	tmp.setFont( font );
	tmp.drawText( 2, 10, s );
	tmp.end();

	p.begin( this );
	p.drawPixmap( r.topLeft(), pix );
	p.end();
}

/** Sets the receive frequency display */
void ChildDisplay::setText( QString _s )
{
    s = _s;
	repaint( FALSE );	
}
