/***************************************************************************
                          fftengine.h  -  description
                             -------------------
    begin                : Mon Oct 11 1999
    copyright            : (C) 1999 by Edson Pereira
    email                : edson_pereira@harvard.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef FFTENGINE_H
#define FFTENGINE_H

#include <qobject.h>
#include <stdio.h>

#define MAX_SAMPLES     2048             /* max sample buffer size */
#define MAX_FFT (MAX_SAMPLES / 2) + 1
#define LIMIT 500

/**
  *@author Edson Pereira
  */

class FftEngine : public QObject {
  Q_OBJECT

public:
	FftEngine();
	~FftEngine();

  int   values[MAX_FFT];

  //void addSample( int sample );

inline void addSample( int sample )
{
   // Do work only whne needed.
   if ( !calculateFlag ) return;

   static float norm = (1.0 / 32767.0); /* for scale to -1.0 .. 1.0 */
   //printf("%d\n", sample );
   // Scale samples and apply window function
   buffer[ cnt ] = value_e[ cnt ] * sample * norm;
   cnt++;
   if (cnt == samples)
   {
      rfft(buffer, samples, 1);         /* do the fft */
      calc_power();                     /* calc power -> pwr array */
      //getmax();                         /* find max value in pwr */
      scale_power(LIMIT);               /* scale power to limit */
      cnt = 0;
      emit fftComplete();
      calculateFlag = false;
   }
}

public slots:
  void setCalculateFlag();

signals: // Signals
  void fftComplete();

private:
  float buffer[MAX_SAMPLES];
  float value_e[MAX_SAMPLES];
  float pwr[MAX_FFT];
  int   cnt;
  int   samples;                     /* Size of the sample */
  int   ffts;                        /* Number of filters */
  float max;
  int   maxi;
  int   delta;
  bool  calculateFlag;

  inline float sqr(float arg)
  {
     return arg * arg;
  }

  inline void swap(float &a, float &b)
  {
     float t = a; a = b; b = t;
  }

  void scale_power( int limit );
  void getmax();
  void calc_power();
	void window( float );
  void rfft(float data[], int N, int isign);
  void fft(float data[], int N, int isign);


};

#endif













