from formField import IMAGE_EXTENSIONS
import ct

def create_settings(config_paths=None,options=None):
    settings    = {
        'create_missing_folders'    : True,
        'extensions'                : IMAGE_EXTENSIONS,
        'recursive'                 : False,
        'stop_for_errors'           : True,
        'overwrite_existing_images' : False,
        'check_images_first'        : True,
        'save_metadata'             : False,#bool(pil.exif),
        #console
        'console'                   : False,
        'interactive'               : False,
        'verbose'                   : True,
        #gui
        'description'               : True,
        'droplet'                   : False,
        'droplet_path'              : ct.USER_PATH,
        'file_history'              : [],
        'image_inspector'           : False,
        'paths'                     : [ct.USER_PATH],
        #internal
        'overwrite_existing_images_forced'  : False,
    }
    if options:
        for attr in settings:
            if hasattr(options,attr):
                settings[attr]      = getattr(options,attr)
    if config_paths == None:
        config_paths    = init_config_paths()
    settings.update(config_paths)
    return settings
