# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

import re

import regex
from unicoding import ensure_unicode

REVERSE = {}
DOT     = '.'

def new(*x):
    return 'new'+DOT+DOT.join(x)

def _to_english(match):
    return '<%s>'%_r(match.group(1))

def to_english(x):
    _x  = _r(ensure_unicode(x))
    if x != _x:
        return _x
    return regex.VARIABLE.sub(_to_english,x)

def _to_local(match):
    return '<%s>'%_(match.group(1))

def to_local(x):
    _x  = _(x)
    if x != _x:
        return _x
    return regex.VARIABLE.sub(_to_local,x)

def _t(phrase):
    REVERSE[_(phrase)]    = phrase
    return phrase
        
def _r(phrase):
    return REVERSE.get(phrase,phrase)


