#!/usr/bin/python
# -*- coding: utf-8 -*-

# Phatch - Photo Batch Processor
# Copyright (C) 2009 Juho Vepsäläinen, www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.
#
# Follows PEP8
import test_actions
from test_actions import system_path

test_actions.DISABLE.remove('blender')


class PreviewGenerator:
    action = None
    previewer = None
    option_name = ''
    options = {}

    def get_base_path(self):
        return '../data/' + self.action + '/preview/'
    base_path = property(get_base_path)

    def generate(self):
        pass

    def get_output_path(self):
        pass


class Preview(test_actions.PhatchTest):

    def __init__(self, action, options, output):
        super(Preview, self).__init__(input=system_path(Preview.DEFAULT_INPUT),
            output=output, log=Preview.DEFAULT_LOG, clean_paths=False)
        self.action = action
        self.options = options

    def get_action_names(self):
        return ['blender', 'save', ]

    def get_output_filename(self, filename, file_action):
        try:
            ftype = file_action.get_field_string('As')
            if ftype == '<type>':
                ftype = '%(type)s'
        except KeyError:
            ftype = '%(type)s'

        return '%s.%s' % (filename, ftype)

    def get_save_filename(self, file):
        return file

    def execute(self):
        choices = []
        test_actions.build_choice_map(self.options, choices)
        actionlists = self.generate_preview_actionlists(self.action, choices)
        self.execute_actionlists(actionlists)
