<?php

/*
	Phoronix Test Suite
	URLs: http://www.phoronix.com, http://www.phoronix-test-suite.com/
	Copyright (C) 2008, Phoronix Media
	Copyright (C) 2004-2008, Michael Larabel
	email_results.php: A simple "dummy" module to demonstrate the PTS functions

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

class email_results extends pts_module_interface
{
	const module_name = "E-Mail Results";
	const module_version = "0.1.0";
	const module_description = "This is a module that will email the test results to an individual with the recipient email address being set in the EMAIL_RESULTS_TO environmental variable.";
	const module_author = "Michael Larabel";

	public static function __post_option_process($process)
	{
		if(($buffer = pts_text_save_buffer($to_add)) != null && getenv("EMAIL_RESULTS_TO") != FALSE && $process == "run_test")
		{
			$email_to = trim(getenv("EMAIL_RESULTS_TO"));

			$email_contents .= "This e-mail was automatically generated by the Phoronix Test Suite with the email_results module.\n";
			$email_contents .= pts_string_header("Phoronix Test Suite v" . PTS_VERSION . " (" . PTS_CODENAME . ")");
			$email_contents .= pts_hw_string() . "\n\n";
			$email_contents .= pts_sw_string() . "\n";
			$email_contents .= $buffer;

			$email_contents = wordwrap($email_contents, 70);
			@mail($email_to, "Phoronix Test Suite - Test Results", $email_contents);
		}
	}
}

?>
