/*
    RawSpeed - RAW file decoder.

    Copyright (C) 2018 Roman Lebedev

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include <utility> // for move

namespace rawspeed {

template <class T> class Optional final {
  T data;
  bool hasData = false;

public:
  Optional() = default;

  explicit Optional(T RHS) : data(RHS), hasData(true) {}

  Optional& operator=(T RHS) {
    Optional tmp(RHS);
    *this = std::move(tmp);
    return *this;
  }

  bool hasValue() const { return hasData; }

  void reset() { hasData = false; }

  T getValue() const {
    assert(hasValue());
    return data;
  }
};

} // namespace rawspeed
