// Need to create a class which will provide list entries for the effect selector
// Subclasses will provide entries from the list of available effects, and from the
// current effects attached to an image.
// Each subclass will have an "Action" method, which will be called when the item
// is double-clicked.

#ifndef EFFECTLIST_H

#include "ppeffect.h"

class EffectListItem
{
	public:
	EffectListItem()
	{
	}
	virtual ~EffectListItem()
	{
	}
	virtual bool Action()=0;
	virtual GdkPixbuf *GetIcon()=0;
	virtual void Remove()=0;
	const char *name;
};


class EffectListSource
{
	public:
	EffectListSource()
	{
	}
	virtual ~EffectListSource()
	{
	}
	virtual int EffectCount()=0;
	virtual EffectListItem *GetEffect(int item)=0;
	private:
};


class AvailableEffectSource : public EffectListSource
{
	public:
	AvailableEffectSource(PPEffectHeader &header);
	virtual ~AvailableEffectSource();
	virtual int EffectCount();
	virtual EffectListItem *GetEffect(int item);
	private:
	PPEffectHeader &header;
};


class CurrentEffectSource : public EffectListSource
{
	public:
	CurrentEffectSource(PPEffectHeader &header,GdkPixbuf *preview);
	virtual ~CurrentEffectSource();
	virtual int EffectCount();
	virtual EffectListItem *GetEffect(int item);
	private:
	PPEffectHeader &header;
	GdkPixbuf *preview;
};

#endif
