#include <iostream>
#include <stdlib.h>
#include <string.h>

#include "imagesource_util.h"
#include "imagesource_dither.h"
#include "imagesource_solid.h"
#include "imagesource_cms.h"
#include "imagesource_desaturate.h"
#include "imagesource_rotate.h"
#include "../support/tiffsave.h"


int main(int argc,char **argv)
{
	try
	{
#if 0
		if(argc==4)
		{
			int tempchange=atoi(argv[2]);
			ImageSource *is=ISLoadImage(argv[1]);

			CMSRGBGamma RGBGamma(2.2,2.2,2.2);
			CMSGamma	GreyGamma(2.2);
			CMSWhitePoint srcwp(6500+tempchange);
			CMSWhitePoint dstwp(6500);
			CMSProfile *source;
			switch(STRIP_ALPHA(is->type))
			{
				case IS_TYPE_RGB:
					is=new ImageSource_Desaturate(is);
					source=new CMSProfile(CMSPrimaries_Rec709,RGBGamma,srcwp);
					break;
				case IS_TYPE_GREY:
					source=new CMSProfile(GreyGamma,srcwp);
					break;
				default:
					throw "Only RGB and Greyscale images are currently supported";
			}
			if(!source)
				throw "Can't create source profile";

			CMSProfile dest(CMSPrimaries_Rec709,RGBGamma,dstwp);
			CMSTransform transform(source,&dest,LCMSWRAPPER_INTENT_ABSOLUTE_COLORIMETRIC);
			is=new ImageSource_CMS(is,&transform);
			delete source;
			TIFFSaver ts(argv[3],is);
			Progress p;
			ts.SetProgress(&p);
			ts.Save();
			delete is;
		}
#endif
#if 0
		if(argc==5)
		{
			ImageSource *is=ISLoadImage(argv[1]);
			int w=atoi(argv[2]);
			int h=atoi(argv[3]);
			is=new ImageSource_Downsample(is,w,h);
			TIFFSaver ts(argv[4],is);
			Progress p;
			ts.SetProgress(&p);
			ts.Save();
			delete is;
		}
#endif
		if(argc==3)
		{
			ImageSource *is=ISLoadImage(argv[1]);
			is=new ImageSource_Rotate(is,180);
			TIFFSaver ts(argv[2],is);
			Progress p;
			ts.SetProgress(&p);
			ts.Save();
			delete is;
		}
	}
	catch(const char *err)
	{
		cerr << "Error: " << err << endl;
	}
	return(0);
}
