/*
 *  Copyright (C) 2004 - 2005 Gareth Ardron <gareth@fission.org.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#ifndef PHP_CLAM_H
#define PHP_CLAM_H

extern zend_module_entry clam_module_entry;
#define phpext_clam_ptr &clam_module_entry

#ifdef PHP_WIN32
#define PHP_CLAM_API __declspec(dllexport)
#else
#define PHP_CLAM_API
#endif

#ifdef ZTS
#include "TSRM.h"
#endif

PHP_MINIT_FUNCTION(clam);
PHP_MSHUTDOWN_FUNCTION(clam);
PHP_RINIT_FUNCTION(clam);
PHP_RSHUTDOWN_FUNCTION(clam);
PHP_MINFO_FUNCTION(clam);

PHP_FUNCTION(clam_scan_buffer);
PHP_FUNCTION(clam_scan_file);
PHP_FUNCTION(clam_get_version);
PHP_FUNCTION(clam_test);

/* 
  	Declare any global variables you may need between the BEGIN
	and END macros here: */    

ZEND_BEGIN_MODULE_GLOBALS(clam)
	char *virus_dbdir;
	long recursion_level;
	long max_files;
	long memory_limit;
ZEND_END_MODULE_GLOBALS(clam)


/* In every utility function you add that needs to use variables 
   in php_clam_globals, call TSRMLS_FETCH(); after declaring other 
   variables used by that function, or better yet, pass in TSRMLS_CC
   after the last function argument and declare your utility function
   with TSRMLS_DC after the last declared argument.  Always refer to
   the globals in your function as CLAM_G(variable).  You are 
   encouraged to rename these macros something shorter, see
   examples in any other php module directory.
*/

#ifdef ZTS
#define CLAM_G(v) TSRMG(clam_globals_id, zend_clam_globals *, v)
#define CLAM_LS_FETCH() imlib2)globals *imlib2_globals = ts_resource(clam_id)
#else
#define CLAM_G(v) (clam_globals.v)
#define CLAM_LS_FETCH()
#endif


#endif	/* PHP_CLAM_H */

