<?php

/**
 * The LuaSandbox class creates a Lua environment and allows for execution of
 * Lua code.
 */
class LuaSandbox {

	const SAMPLES = 0;
	const SECONDS = 1;
	const PERCENT = 2;

	/**
	 * Return the versions of LuaSandbox and Lua
	 * @return array With two keys
	 *  - LuaSandbox: (string) LuaSandbox version
	 *  - Lua: (string) Lua version
	 */
	public static function getVersionInfo() {
	}

	/**
	 * Load Lua code into the Lua environment.
	 *
	 * This is the equivalent of standard Lua's `loadstring()` function.
	 *
	 * @param string $code Lua code
	 * @param string $chunkName Name for the loaded chunk, for use in error
	 *  traces
	 * @return LuaSandboxFunction The compiled chunk
	 */
	public function loadString( $code, $chunkName = '' ) {
	}

	/**
	 * Load a precompiled binary chunk into the Lua environment.
	 *
	 * Loads data generated by LuaSandboxFunction::dump().
	 *
	 * @param string $binary Data from LuaSandboxFunction::dump()
	 * @param string $chunkName Name for the loaded function.
	 * @return LuaSandboxFunction
	 */
	public function loadBinary( $binary, $chunkName = '' ) {
	}

	/**
	 * Set the memory limit for the Lua environment.
	 *
	 * If this limit is exceeded, a LuaSandboxMemoryError exception is thrown.
	 *
	 * @param int $limit Memory limit in bytes
	 */
	public function setMemoryLimit( $limit ) {
	}

	/**
	 * Fetch the current memory usage of the Lua environment.
	 * @return int Current memory usage in bytes.
	 */
	public function getMemoryUsage() {
	}

	/**
	 * Fetch the peak memory usage of the Lua environment.
	 * @return int Peak memory usage in bytes.
	 */
	public function getPeakMemoryUsage() {
	}

	/**
	 * Set the CPU time limit for the Lua environment.
	 *
	 * If the total user and system time used by the environment after the call
	 * to this method exceeds this limit, a LuaSandboxTimeoutError exception is
	 * thrown.
	 *
	 * Time used in PHP callbacks is included in the limit.
	 *
	 * Setting the time limit from a callback while Lua is running causes the
	 * timer to be reset, or started if it was not already running.
	 *
	 * @param float|false $limit Limit in seconds, or false for no limit
	 */
	public function setCPULimit( $limit ) {
	}

	/**
	 * Fetch the current CPU time usage of the Lua environment.
	 *
	 * This includes time spend in PHP callbacks.
	 *
	 * @return float Current CPU time usage in seconds.
	 */
	public function getCPUUsage() {
	}

	/**
	 * Pause the CPU usage timer
	 *
	 * This only has effect when called from within a callback from Lua. When
	 * execution returns to Lua, the timer will be automatically unpaused. If
	 * a new call into Lua is made, the timer will be unpaused for the
	 * duration of that call.
	 *
	 * If a PHP callback calls into Lua again with timer not paused, and then
	 * that Lua function calls into PHP again, the second PHP call will not be
	 * able to pause the timer. The logic is that even though the second PHP
	 * call would avoid counting the CPU usage against the limit, the first
	 * call still counts it.
	 *
	 * @return bool true if the timer is now paused, false if not.
	 */
	public function pauseUsageTimer() {
	}

	/**
	 * Unpause the timer paused by LuaSandbox::pauseUsageTimer()
	 */
	public function unpauseUsageTimer() {
	}

	/**
	 * Enable the profiler. Profiling will begin when Lua code is entered.
	 *
	 * The profiler periodically samples the Lua environment to record the
	 * running function. Testing indicates that at least on Linux, setting a
	 * period less than 1ms will lead to a high overrun count but no
	 * performance problems.
	 *
	 * @param float $period Sampling period in seconds
	 * @return bool Whether the profiler is enabled.
	 */
	public function enableProfiler( $period = 0.002 ) {
	}

	/**
	 * Disable the profiler.
	 */
	public function disableProfiler() {
	}

	/**
	 * Fetch profiler data.
	 *
	 * For a profiling instance previously started by enableProfiler(), get a
	 * report of the cost of each function. The return value will be an
	 * associative array mapping the function name (with source file and line
	 * defined in angle brackets) to the cost.
	 *
	 * The measurement unit used for the cost is determined by the what
	 * parameter:
	 *   - LuaSandbox::SAMPLES: Measure in number of samples
	 *   - LuaSandbox::SECONDS: Measure in seconds of CPU time
	 *   - LuaSandbox::PERCENT: Measure percentage of CPU time
	 *
	 * @param int $what Measurement unit constant.
	 * @return array Profiler measurements, sorted in descending order.
	 */
	public function getProfilerFunctionReport( $what = LuaSandbox::SECONDS ) {
	}

	/**
	 * Call a function in a Lua global variable
	 *
	 * If the name contains "." characters, the function is located via
	 * recursive table accesses, as if the name were a Lua expression.
	 *
	 * If the variable does not exist, or is not a function, false will be
	 * returned and a warning issued.
	 *
	 * For more information about calling Lua functions and the return values,
	 * see LuaSandboxFunction::call().
	 *
	 * @param string $name Variable name
	 * @param mixed $args,... Arguments to the function
	 * @return array|bool Return values from the function
	 */
	public function callFunction( $name /* ... */ ) {
	}

	/**
	 * Wrap a PHP callable in a LuaSandboxFunction, so it can be passed into
	 * Lua as an anonymous function.
	 *
	 * The function must return either an array of values (which may be empty),
	 * or null which is equivalent to returning the empty array.
	 *
	 * Exceptions will be raised as errors in Lua, however only
	 * LuaSandboxRuntimeError exceptions may be caught inside Lua with
	 * `pcall()` or `xpcall()`.
	 *
	 * For more information about calling Lua functions and the return values,
	 * see LuaSandboxFunction::call().
	 *
	 * @param callable $function
	 * @return LuaSandboxFunction
	 */
	public function wrapPhpFunction( callable $function ) {
	}

	/**
	 * Register a set of PHP functions as a Lua library, so that Lua can call
	 * the relevant PHP code.
	 *
	 * The first parameter is the name of the library. In the Lua state, the
	 * global variable of this name will be set to the table of functions. If
	 * the table already exists, the new functions will be added to it.
	 *
	 * The second parameter is an array, where each key is a function name, and
	 * each value is a corresponding PHP callable.
	 *
	 * For more information about calling Lua functions and the return values,
	 * see LuaSandboxFunction::call() and LuaSandbox::wrapPhpFunction().
	 *
	 * @param string $libName Library name
	 * @param array $functions As above
	 */
	public function registerLibrary( $libName, array $functions ) {
	}
}
