--TEST--
maxdb_get_metadata
--FILE--
<?php
	include "connect.inc";
	
	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

        maxdb_report (MAXDB_REPORT_OFF);
  	maxdb_query($link,"DROP TABLE test_store_result");
        maxdb_report (MAXDB_REPORT_ERROR);

  	maxdb_query($link,"CREATE TABLE test_store_result (a int)");

	maxdb_query($link, "INSERT INTO test_store_result VALUES (1)");
	maxdb_query($link, "INSERT INTO test_store_result VALUES (2)");
	maxdb_query($link, "INSERT INTO test_store_result VALUES (3)");

	$stmt = maxdb_prepare($link, "SELECT * FROM test_store_result");
	maxdb_execute($stmt);

	/* this should produce an out of sync error */
	if ($result = maxdb_query($link, "SELECT * FROM test_store_result")) {
		maxdb_free_result($result);
		printf ("Query ok\n");
	}
	maxdb_stmt_close($stmt);

	$stmt = maxdb_prepare($link, "SELECT * FROM test_store_result");
	maxdb_execute($stmt);
	$result1 = maxdb_get_metadata($stmt);
	maxdb_stmt_store_result($stmt);

	printf ("Rows: %d\n", maxdb_stmt_affected_rows($stmt));

	/* this should show an error, cause results are not buffered */
	if ($result = maxdb_query($link, "SELECT * FROM test_store_result")) {
		$row = maxdb_fetch_row($result);
		maxdb_free_result($result);
	} 
	

	var_dump($row);	

	maxdb_free_result($result1);
	maxdb_stmt_close($stmt);
	maxdb_close($link);
?>
--EXPECT--
Query ok
Rows: 3
array(1) {
  [0]=>
  int(1)
}
