<?php
/** 
*
* ucp [Catalan]
*
* @package language
* @version $Id: ucp.php 9478 2009-04-22 13:08:23Z acydburn $
* @copyright (c) 2005 phpBB Group 
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Privacy policy and T&C
$lang = array_merge($lang, array(
	'TERMS_OF_USE_CONTENT'	=> 'En accedir a “%1$s” (a partir d’ara “nosaltres”, “%1$s”, “%2$s”), accepteu les condicions legals següents. Si no accepteu totes les condicions legals següents, si us plau no accediu ni utilitzeu “%1$s”. Aquestes condicions poden canviar en qualsevol moment i ens esforçarem al màxim per informar-vos. Això no obstant, és recomanable que les reviseu regularment ja que l’ús continuat de “%1$s” després que aquestes canvïin implica que les accepteu a mesura que s’actualitzen o s’esmenen.<br />
	<br />
	Els nostres fòrums utilitzen phpBB (a partir d’ara “ells”, “el phpBB”, “www.phpbb.com”, “phpBB Group”, “phpBB Teams”) un programa per a la creació de fòrums distribuït sota la “<a href="http://opensource.org/licenses/gpl-license.php">Llicència pública general</a>” (a partir d’ara la “GPL”) que us podeu baixar des de <a href="http://www.phpbb.com/">www.phpbb.com</a>. El phpBB només facilita els debats a través d’Internet, el phpBB Group no és responsable de què permet o no en termes de cotingut o conducta. Per a més informació sobre el phpBB, dirigiu-vos a: <a href="http://www.phpbb.com/">http://www.phpbb.com/</a>.<br />
	<br />
	Accepteu no publicar material abusiu, obscè, vulgar, difamatori, d’odi, amenaçant, orientat sexualment o de qualsevol altre tipus que pugui violar qualsevol de les lleis del vostre país, del país en què “%1$s” està allotjat o qualsevol llei intenacional. Si ho feu, és possible que us expulsin de manera immediata i permanent, amb una notificació al vostre proveïdor d’Internet si fos necessari. L’adreça IP de totes les vostres entrades és enregistrada per ajudar a fer complir aquestes condicions. Accepteu que a “%1$s” tenim dret a eliminar, editar, moure o tancar qualsevol tema quan ho considerem necessari. Com a usuari accepteu que la informació que heu introduït quedi emmagatzemada en una base de dades. Tot i que aquesta informació no es proporcionarà a tercers sense el vostre consentiment, ni “%1$s” ni phpBB assumiran cap responsabilitat per qualsevol atac al sistema que pugui comprometre les dades.
	',

	'PRIVACY_POLICY'		=> 'Aquestes normes expliquen en detall com “%1$s” a més de les seves companyies afiliades (a partir d’ara “nosaltres”, “%1$s”, “%2$s”) i phpBB (a partir d’ara “ells”, “el phpBB”, “www.phpbb.com”, “phpBB Group”, “phpBB Teams”) utilitzen la informació recollida durant una de les vostres sessions (a partir d’ara “la vostra informació”).<br />
	<br />
	La vostra informació es recull de dues maneres diferents. Primerament, navegar per “%1$s” farà que el phpBB creï una sèrie de galetes, uns petis fitxers de text que es baixen com a fitxers temporals del navegador al vostre ordinador. Les dues primeres galetes només contenen un identificador d’usuari (a partir d’ara “id d’usuari”) i un identificador de sessió anònim (a partir d’ara “id de sessió”), que se us assigna automàticament pel phpBB. Es crearà una tercera galeta un cop hagueu navegat pels temes de “%1$s” que s’utilitza per emmagatzemar quins temes ja heu llegit, amb la qual cosa es millora la usabilitat dels fòrums.<br />
	<br />
	És possible que també es creïn galetes externes al phpBB mentre navegueu per “%1$s”, això no obstant, queden fora de l’abast d’aquest document que només pretén cobrir les pàgines creades pel phpBB. La segona manera en què recollim la vostra informació és a través dels continguts que publiqueu. Això inclou però no es limita a: publicar entrades com a usuari anònim (a partir d’ara “entrades anònimes”), registrar-vos a “%1$s” (a partir d’ara “el vostre compte”) i les entrades que publiqueu després de registrar-vos havent iniciat la sessió (a partir d’ara “les vostres entrades”).<br />
	<br />
	El vostre compte contindrà com a mínim un nom identificador únic (a partir d’ara “nom d’usuari”), una contrasenya personal per iniciar la sessió amb el vostre compte (a partir d’ara “contrasenya”) i una adreça electrònica vàlida i personal (a partir d’ara “adreça electrònica”). La informació del vostre compte a “%1$s” està protegida per les lleis de protecció de dades aplicables al país on es troba allotjat el nostre lloc web. Tota informació més enllà del nom d’usuari, contrasenya i adreça electrònica requerits per “%1$s” durant el procés de registrar-vos, és obligatòria o opcional a la discreció de “%1$s”. En qualsevol cas, podeu decidir quina informació del vostre compte es mostra públicament. Addicionalment, des del vostre compte, teniu l’opció d’acceptar o rebutjar que se us enviïn els correus electrònics generats automàticament pel phpBB.<br />
	<br />
	La vostra contrasenya està encriptada amb una funció de resum unidireccional per tal de que sigui segura. Això no obstant, és recomanable que no reutilitzeu la mateixa contrasenya en múltiples llocs web diferents. La vostra contrasenya és el mitjà per accedir al vostre compte a “%1$s”, per tant, teniu-ne cura i sota cap circumstància ningú afiliat amb “%1$s”, phpBB o tercers, us demanarà la vostra contrasenya de manera legítima. Si us oblideu de la vostra contrasenya, podeu utilitzar la funció “He oblidat la meva contrasenya” proporcionada pel phpBB. Aquest procés us demanarà que proporcioneu el vostre nom d’usuari i adreça electrònica, llavors el phpBB generarà una contrasenya nova per que pugueu recuperar el vostre compte.<br />
	',
));

// Common language entries
$lang = array_merge($lang, array(
	'ACCOUNT_ACTIVE'				=> 'S’ha activat el vostre compte. Gràcies per registrar-vos.',
	'ACCOUNT_ACTIVE_ADMIN'			=> 'S’ha activat el compte.',
	'ACCOUNT_ACTIVE_PROFILE'		=> 'S’ha reactivat el vostre compte correctament.',
	'ACCOUNT_ADDED'					=> 'Gràcies per registrar-vos, s’ha creat el vostre compte. Ja podeu iniciar la sessió amb el vostre nom d’usuari i contrasenya.',
	'ACCOUNT_COPPA'					=> 'S’ha creat el vostre compte però cal que sigui aprovat, si us plau comproveu el vostre correu electrònic per més detalls.',
	'ACCOUNT_EMAIL_CHANGED'			=> 'S’ha actualitzat el vostre compte. Això no obstant, aquests fòrums requereixen la reactivació del compte quan es canvia l’adreça electrònica. S’ha enviat una clau de reactivació a la nova adreça electrònica que heu proporcionat. Si us plau comproveu el vostre correu electrònic per a més informació.',
	'ACCOUNT_EMAIL_CHANGED_ADMIN'	=> 'S’ha actualitzat el vostre compte. Això no obstant, aquests fòrums requereixen la reactivació del compte per part dels administradors quan es canvia l’adreça electrònica. Se’ls ha enviat un correu electrònic i se us informarà quan es reactivi el vostre compte.',
	'ACCOUNT_INACTIVE'				=> 'S’ha creat el vostre compte. Això no obstant, aquests fòrums requereixen l’activació dels comptes. S’ha enviat una clau d’activació a la nova adreça electrònica que heu proporcionat. Si us plau comproveu el vostre correu electrònic per a més informació.',
	'ACCOUNT_INACTIVE_ADMIN'		=> 'S’ha creat el vostre compte. Això no obstant, aquests fòrums requereixen l’activació dels comptes per part dels administradors. Se’ls ha enviat un correu electrònic i se us informarà quan s’activi el vostre compte.',
	'ACTIVATION_EMAIL_SENT'			=> 'El correu electrònic d’activació s’ha enviat a la vostra adreça electrònica.',
	'ACTIVATION_EMAIL_SENT_ADMIN'	=> 'S’ha enviat el correu d’activació a les adreces electròniques dels administradors.',
	'ADD'							=> 'Afegeix',
	'ADD_BCC'						=> 'Afegeix [BCC]',
	'ADD_FOES'						=> 'Afegeix enemics nous',
	'ADD_FOES_EXPLAIN'				=> 'Podeu introduir diversos noms d’usuari, cadascun en una línia diferent.',
	'ADD_FOLDER'					=> 'Afegeix una carpeta',
	'ADD_FRIENDS'					=> 'Afegeix amics nous',
	'ADD_FRIENDS_EXPLAIN'			=> 'Podeu introduir diversos noms d’usuari, cadascun en una línia diferent.',
	'ADD_NEW_RULE'					=> 'Afegeix una regla nova',
	'ADD_RULE'						=> 'Afegeix la regla',
	'ADD_TO'						=> 'Afegeix [Per]',
	'ADD_USERS_UCP_EXPLAIN'			=> 'Aquí podeu afegir usuaris nou al grup. Podeu triar si aquest grup passa a ser el nou grup per defecte dels usuaris seleccionats. Introduïu cada nom d’usuari en una línia nova.',
	'ADMIN_EMAIL'					=> 'Els administradors poden enviar-me informació per correu electrònic',
	'AGREE'							=> 'Accepto aquestes condicions',
	'ALLOW_PM'						=> 'Permet que els usuaris m’enviïn missatges privats',
	'ALLOW_PM_EXPLAIN'				=> 'Tingueu en compte que els administradors i els moderadors sempre podran enviar-vos missatges privats.',
	'ALREADY_ACTIVATED'				=> 'Ja heu activat el vostre compte.',
	'ATTACHMENTS_EXPLAIN'			=> 'Aquesta és una llista dels fitxers que heu adjuntat a les entrades d’aquest fòrum.',
	'ATTACHMENTS_DELETED'			=> 'S’han eliminat els fitxers adjunts correctament.',
	'ATTACHMENT_DELETED'			=> 'S’ha eliminat el fitxer adjunt correctament.',
	'AVATAR_CATEGORY'				=> 'Categoria',
	'AVATAR_EXPLAIN'				=> 'Mides màximes; amplària: %1$d píxels, alçària: %2$d píxels, mida del fitxer: %3$.2f KiB.',
	'AVATAR_FEATURES_DISABLED'		=> 'Actualment la funció d’avatars està inhabilitada.',
	'AVATAR_GALLERY'				=> 'Galeria local',
	'AVATAR_GENERAL_UPLOAD_ERROR'	=> 'No s’ha pogut penjar l’avatar a %s.',
	'AVATAR_NOT_ALLOWED'			=> 'No es pot mostrar el vostre avatar perquè els avatars estan inhabilitats.',
	'AVATAR_PAGE'					=> 'Pàgina',
	'AVATAR_TYPE_NOT_ALLOWED'		=> 'El vostre avatar actual no es pot mostrar perquè aquest tipus d’avatar està inhabilitat.',

	'BACK_TO_DRAFTS'			=> 'Torna als esborranys desats',
	'BACK_TO_LOGIN'				=> 'Torna a la pàgina d’inici de sessió',
	'BIRTHDAY'					=> 'Data de naixement',
	'BIRTHDAY_EXPLAIN'			=> 'Si definiu un any, es mostrarà la vostra edat quan sigui el vostre aniversari.',
	'BOARD_DATE_FORMAT'			=> 'Format de data',
	'BOARD_DATE_FORMAT_EXPLAIN'	=> 'La sintaxi utilitzada és idèntica a la de la funció <a href="http://www.php.net/date">date()</a> del PHP.',
	'BOARD_DST'					=> 'L’horari d’estiu/<abbr title="Daylight Saving Time">DST</abbr> està activat',
	'BOARD_LANGUAGE'			=> 'Idioma',
	'BOARD_STYLE'				=> 'Estil del fòrum',
	'BOARD_TIMEZONE'			=> 'Fus horari',
	'BOOKMARKS'					=> 'Adreces d’interès',
	'BOOKMARKS_EXPLAIN'			=> 'Podeu utilitzar les adreces d’interès per referenciar un tema. Seleccioneu la casella de les adreces d’interès que vulgueu eliminar i feu clic sobre el botó <em>Elimina les adreces d’interès marcades</em>.',
	'BOOKMARKS_DISABLED'		=> 'Les adreces d’interès estan inhabilitades en aquest fòrum.',
	'BOOKMARKS_REMOVED'			=> 'S’han eliminat les adreces d’interès correctament.',

	'CANNOT_EDIT_MESSAGE_TIME'	=> 'Ja no podeu editar ni eliminar aquest missatge.',
	'CANNOT_MOVE_TO_SAME_FOLDER'=> 'Els missatges no es poden desplaçar a la mateixa carpeta que voleu eliminar.',
	'CANNOT_MOVE_FROM_SPECIAL'	=> 'Els missatges no es poden desplaçar de la safata de sortida.',
	'CANNOT_RENAME_FOLDER'		=> 'No es pot canviar el nom d’aquesta carpeta.',
	'CANNOT_REMOVE_FOLDER'		=> 'Aquesta carpeta no es pot eliminar.',
	'CHANGE_DEFAULT_GROUP'		=> 'Canvia el grup per defecte',
	'CHANGE_PASSWORD'			=> 'Canvia la contrasenya',
	'CLICK_GOTO_FOLDER'			=> '%1$sVes a la meva carpeta “%3$s”%2$s',
	'CLICK_RETURN_FOLDER'		=> '%1$sTorna a la meva carpeta “%3$s”%2$s',
	'CONFIRMATION'				=> 'Confirmació de registre',
	'CONFIRM_CHANGES'			=> 'Confirma els canvis',
	'CONFIRM_EMAIL'				=> 'Confirmeu l’adreça electrònica',
	'CONFIRM_EMAIL_EXPLAIN'		=> 'Només cal que l’especifiqueu si voleu canviar la vostra adreça electrònica.',
	'CONFIRM_EXPLAIN'			=> 'Per tal de prevenir els registres automàtics cal que introduïu un codi de confirmació. El codi es mostra en la imatge que veieu a sota. Si teniu problemes de visió o per alguna raó no podeu llegir aquest codi, si us plau poseu-vos en contacte amb l’%sadministrador del fòrum%s.',
	'VC_REFRESH'				=> 'Refresca el codi de confirmació',
	'VC_REFRESH_EXPLAIN'		=> 'Si no podeu llegir el codi, podeu demanar-ne un de nou fent clic al botó.',

	'CONFIRM_PASSWORD'			=> 'Confirmeu la contrasenya',
	'CONFIRM_PASSWORD_EXPLAIN'	=> 'Només cal que confirmeu la contrasenya si l’heu canviada a sobre.',
	'COPPA_BIRTHDAY'			=> 'Per continuar amb el procediment de registre digueu quan vau néixer.',
	'COPPA_COMPLIANCE'			=> 'Compliment de COPPA',
	'COPPA_EXPLAIN'				=> 'Tingueu en compte que en fer clic a Tramet es crearà el vostre compte. Això no obstant, no es pot activar fins que un dels vostres pares o tutors aprovi el vostre registre. Se us enviarà per correu electrònic una còpia del formulari necessari amb els detalls d’on l’heu d’enviar.',
	'CREATE_FOLDER'				=> 'Afegeix una carpeta…',
	'CURRENT_IMAGE'				=> 'Imatge actual',
	'CURRENT_PASSWORD'			=> 'Contrasenya actual',
	'CURRENT_PASSWORD_EXPLAIN'	=> 'Cal que confirmeu la vostra contrasenya quan la canvieu, o canvieu la vostra adreça electrònica o nom d’usuari.',
	'CUR_PASSWORD_ERROR'		=> 'La contrasenya que heu introduït no és correcta.',
	'CUSTOM_DATEFORMAT'			=> 'Personalitzada…',

	'DEFAULT_ACTION'			=> 'Acció per defecte',
	'DEFAULT_ACTION_EXPLAIN'	=> 'S’activarà aquesta acció si cap de les anteriors és aplicable.',
	'DEFAULT_ADD_SIG'			=> 'Inclou la meva signatura per defecte',
	'DEFAULT_BBCODE'			=> 'Habilita el BBCode per defecte',
	'DEFAULT_NOTIFY'			=> 'Avisa’m de les respostes per defecte',
	'DEFAULT_SMILIES'			=> 'Habilita les emoticones per defecte',
	'DEFINED_RULES'				=> 'Regles definides',
	'DELETED_TOPIC'				=> 'S’ha eliminat el tema.',
	'DELETE_ATTACHMENT'			=> 'Elimina el fitxer adjunt',
	'DELETE_ATTACHMENTS'		=> 'Elimina els fitxers adjunts',
	'DELETE_ATTACHMENT_CONFIRM'	=> 'Esteu segur que voleu eliminar aquest fitxer adjunt?',
	'DELETE_ATTACHMENTS_CONFIRM'=> 'Esteu segur que voleu eliminar aquests fitxers adjunts?',
	'DELETE_AVATAR'				=> 'Elimina la imatge',
	'DELETE_COOKIES_CONFIRM'	=> 'Esteu segur que voleu eliminar totes les galetes creades pel fòrum?',
	'DELETE_MARKED_PM'			=> 'Elimina els missatges marcats',
	'DELETE_MARKED_PM_CONFIRM'	=> 'Esteu segur que voleu eliminar els missatges marcats?',
	'DELETE_OLDEST_MESSAGES'	=> 'Elimina els missatges més antics',
	'DELETE_MESSAGE'			=> 'Elimina el missatge',
	'DELETE_MESSAGE_CONFIRM'	=> 'Esteu segur que voleu eliminar aquest missatge privat?',
	'DELETE_MESSAGES_IN_FOLDER'	=> 'Suprimeix tots els missatges de la carpeta eliminada',
	'DELETE_RULE'				=> 'Elimina la regla',
	'DELETE_RULE_CONFIRM'		=> 'Esteu segur que voleu eliminar aquesta regla?',
	'DEMOTE_SELECTED'			=> 'Renuncia al lideratge dels grups seleccionats',
	'DISABLE_CENSORS'			=> 'Habilita la censura de paraules',
	'DISPLAY_GALLERY'			=> 'Mostra la galeria',
	'DOMAIN_NO_MX_RECORD_EMAIL'	=> 'El domini de l’adreça electrònica introduïda no té un registre d’intercanvi de correu vàlid.',
	'DOWNLOADS'					=> 'Baixades',
	'DRAFTS_DELETED'			=> 'S’han eliminat correctament tos els esborranys seleccionats.',
	'DRAFTS_EXPLAIN'			=> 'Aquí podeu visualitzar, editar, i eliminar els esborranys que heu desat.',
	'DRAFT_UPDATED'				=> 'S’ha actualitzat l’esborrany correctament.',

	'EDIT_DRAFT_EXPLAIN'		=> 'Aquí podeu editar el vostre esborrany. Els esborranys no contenen informació d’enquestes ni fitxers adjunts.',
	'EMAIL_BANNED_EMAIL'		=> 'L’adreça electrònica que heu introduït no està permesa.',
	'EMAIL_INVALID_EMAIL'		=> 'L’adreça electrònica que heu introduït no és vàlida.',
	'EMAIL_REMIND'				=> 'Aquesta ha de ser l’adreça electrònica associada al vostre compte. Si no l’heu canviada al Tauler de control de l’usuari, és l’adreça amb la que vau registrar el vostre compte.',
	'EMAIL_TAKEN_EMAIL'			=> 'L’adreça electrònica que heu introduït ja està utilitzada.',
	'EMPTY_DRAFT'				=> 'Heu d’introduir un missatge per trametre els canvis.',
	'EMPTY_DRAFT_TITLE'			=> 'Heu d’introduir un títol per a l’esborrany.',
	'EXPORT_AS_XML'				=> 'Exporta a XML',
	'EXPORT_AS_CSV'				=> 'Exporta a CSV',
	'EXPORT_AS_CSV_EXCEL'		=> 'Exporta a CSV (Excel)',
	'EXPORT_AS_TXT'				=> 'Exporta a TXT',
	'EXPORT_AS_MSG'				=> 'Exporta a MSG',
	'EXPORT_FOLDER'				=> 'Exporta aquesta vista',

	'FIELD_REQUIRED'					=> 'El camp “%s” s’ha d’emplenar.',
	'FIELD_TOO_SHORT'					=> 'El camp “%1$s” és massa curt, calen un mínim de %2$d caràcters.',
	'FIELD_TOO_LONG'					=> 'El camp “%1$s” és massa llarg, es permet un màxim de %2$d caràcters.',
	'FIELD_TOO_SMALL'					=> 'El valor de “%1$s” és massa petit, cal un valor mínim de %2$d.',
	'FIELD_TOO_LARGE'					=> 'El valor de “%1$s” és massa gran, es permet un valor màxim de %2$d.',
	'FIELD_INVALID_CHARS_NUMBERS_ONLY'	=> 'El camp “%s” conte caràcters no vàlids, només es permeten números.',
	'FIELD_INVALID_CHARS_ALPHA_ONLY'	=> 'El camp “%s” conte caràcters no vàlids, només es permeten caràcters alfanumèrics.',
	'FIELD_INVALID_CHARS_SPACERS_ONLY'	=> 'El camp “%s” conte caràcters no vàlids, només es permeten caràcters alfanumèrics, espais o -+_[]',
	'FIELD_INVALID_DATE'				=> 'El camp “%s” conté una data no vàlida.',
	'FIELD_INVALID_VALUE'				=> 'El camp “%s” conté un valor no vàlid.',

	'FOE_MESSAGE'				=> 'Missatge d’un enemic',
	'FOES_EXPLAIN'				=> 'Els enemics són usuaris que són ignorats per defecte. Les entrades d’aquests usuaris no seran completament visibles. El missatges personals dels enemics sí que es permeten. Tingueu en compte que no podeu ignorar els moderadors o els administradors.',
	'FOES_UPDATED'				=> 'S’ha actualitzat la vostra llista d’enemics correctament.',
	'FOLDER_ADDED'				=> 'S’ha afegit la carpeta correctament.',
	'FOLDER_MESSAGE_STATUS'		=> '%1$d missatges emmagatzemats de %2$d',
	'FOLDER_NAME_EMPTY'			=> 'Cal que introduïu un nom per aquesta carpeta.',
	'FOLDER_NAME_EXIST'			=> 'La carpeta <strong>%s</strong> ja existeix.',
	'FOLDER_OPTIONS'			=> 'Opcions de la carpeta',
	'FOLDER_RENAMED'			=> 'S’ha canviat el nom de la carpeta correctament.',
	'FOLDER_REMOVED'			=> 'S’ha eliminat correctament la carpeta.',
	'FOLDER_STATUS_MSG'			=> 'La utilització de la carpeta és del %1$d%% (%2$d missatges emmagatzemats de %3$d)',
	'FORWARD_PM'				=> 'Reenvia el MP',
	'FORCE_PASSWORD_EXPLAIN'	=> 'Abans de continuar navegant pel fòrum cal que canvieu la vostra contrasenya.',
	'FRIEND_MESSAGE'			=> 'Missatge d’un amic',
	'FRIENDS'					=> 'Amics',
	'FRIENDS_EXPLAIN'			=> 'Els amics us permeten accedir ràpidament als usuaris amb els quals us comuniqueu sovint. Si la plantilla ho implementa, les entrades fetes per un amic estaran realçades.',
	'FRIENDS_OFFLINE'			=> 'Desconnectat',
	'FRIENDS_ONLINE'			=> 'Connectat',
	'FRIENDS_UPDATED'			=> 'S’ha actualitzat correctament la vostra llista d’amics.',
	'FULL_FOLDER_OPTION_CHANGED'=> 'S’ha canviat correctament l’acció a empendre quan una carpeta és plena.',
	'FWD_ORIGINAL_MESSAGE'		=> '-------- Missatge original --------',
	'FWD_SUBJECT'				=> 'Assumpte: %s',
	'FWD_DATE'					=> 'Data: %s',
	'FWD_FROM'					=> 'Remitent: %s',
	'FWD_TO'					=> 'Destinatari: %s',

	'GLOBAL_ANNOUNCEMENT'		=> 'Avís global',

	'HIDE_ONLINE'				=> 'Oculta la meva presència quan estic connectat',
	'HIDE_ONLINE_EXPLAIN'		=> 'El canvi en aquesta configuració no es farà efectiu fins al següent cop que visiteu el fòrum.',
	'HOLD_NEW_MESSAGES'			=> 'No acceptis missatges nous (els missatges nous es retindran fins que hi hagi prou espai disponible)',
	'HOLD_NEW_MESSAGES_SHORT'	=> 'Els missatges nous es retindran',

	'IF_FOLDER_FULL'			=> 'Si la carpeta és plena',
	'IMPORTANT_NEWS'			=> 'Avisos importants',
	'INVALID_USER_BIRTHDAY'			=> 'L’aniversari introduït no és una data vàlida.',
	'INVALID_CHARS_USERNAME'	=> 'El nom d’usuari conté caràcters no permesos.',
	'INVALID_CHARS_NEW_PASSWORD'=> 'La contrasenya no conté els caràcters necessaris.',
	'ITEMS_REQUIRED'			=> 'Els elements marcats amb * són camps necessaris del perfil i s’han d’emplenar obligatòriament.',

	'JOIN_SELECTED'				=> 'Sol·licita l’afiliació als grups seleccionats',

	'LANGUAGE'					=> 'Idioma',
	'LINK_REMOTE_AVATAR'		=> 'Enllaça amb una adreça externa',
	'LINK_REMOTE_AVATAR_EXPLAIN'=> 'Introduïu l’URL on està ubicada la imatge que voleu enllaçar per al vostre avatar.',
	'LINK_REMOTE_SIZE'			=> 'Mides de l’avatar',
	'LINK_REMOTE_SIZE_EXPLAIN'	=> 'Especifiqueu l’amplària i l’alçària de l’avatar, deixeu-les en blanc per intentar la verificació automàtica.',
	'LOGIN_EXPLAIN_UCP'			=> 'Si us plau inicieu la sessió per accedir al Tauler de control de l’usuari.',
	'LOGIN_REDIRECT'			=> 'Heu iniciat la sessió correctament.',
	'LOGOUT_FAILED'				=> 'No heu finalitzat la sessió ja que la sol·licitud no coincidia amb la vostra sessió. Si us plau poseu-vos en contacte amb l’administrador del fòrum si contineu expermientant aquest problema.',
	'LOGOUT_REDIRECT'			=> 'Heu finalitzat la sessió correctament.',

	'MARK_IMPORTANT'				=> 'Marca/desmarca com a important',
	'MARKED_MESSAGE'				=> 'Missatge marcat',
	'MAX_FOLDER_REACHED'			=> 'Heu arrivat al nombre màxim permès de carpetes definides per l’usuari.',
	'MESSAGE_BY_AUTHOR'				=> 'autor:',
	'MESSAGE_COLOURS'				=> 'Colors del missatge',
	'MESSAGE_DELETED'				=> 'S’ha eliminat el missatge correctament.',
	'MESSAGE_HISTORY'				=> 'Historial de missatges',
	'MESSAGE_REMOVED_FROM_OUTBOX'	=> 'Aquest missatge ha estat eliminat pel seu autor abans que fos entregat.',
	'MESSAGE_SENT_ON'				=> 'data:',
	'MESSAGE_STORED'				=> 'S’ha enviat el missatge correctament.',
	'MESSAGE_TO'					=> 'Per',
	'MESSAGES_DELETED'				=> 'S’han eliminat els missatges correctament',
	'MOVE_DELETED_MESSAGES_TO'		=> 'Desplaça els missatges de la carpeta eliminada a',
	'MOVE_DOWN'						=> 'Baixa',
	'MOVE_MARKED_TO_FOLDER'			=> 'Desplaça els missatges marcats a %s',
	'MOVE_PM_ERROR'					=> 'S’ha produït un error mentre es movien els missatges a la carpeta nova, només s’han mogut %1d missatges de %2d.',
	'MOVE_TO_FOLDER'				=> 'Desplaça’l a la carpeta',
	'MOVE_UP'						=> 'Puja',

	'NEW_EMAIL_ERROR'				=> 'Les adreces alectròniques que heu introduït no coincideixen.',
	'NEW_FOLDER_NAME'				=> 'Nom de la carpeta nova',
	'NEW_PASSWORD'					=> 'Contrasenya nova',
	'NEW_PASSWORD_ERROR'			=> 'Les contrasenyes que heu heu introduït no coincideixen.',
	'NOTIFY_METHOD'					=> 'Mètode de notificació',
	'NOTIFY_METHOD_BOTH'			=> 'Ambdós',
	'NOTIFY_METHOD_EMAIL'			=> 'Només per correu electrònic',
	'NOTIFY_METHOD_EXPLAIN'			=> 'Mètode utilitzat per als missatges enviats a través del fòrum.',
	'NOTIFY_METHOD_IM'				=> 'Només via Jabber',
	'NOTIFY_ON_PM'					=> 'Avisa’m quan rebi missatges privats nous',
	'NOT_ADDED_FRIENDS_ANONYMOUS'	=> 'No podeu afegir l’usuari anònim a la llista d’amics.',
	'NOT_ADDED_FRIENDS_BOTS'		=> 'No podeu afegir robots a la llista d’amics.',
	'NOT_ADDED_FRIENDS_FOES'		=> 'No podeu afegir usuaris de la llista d’enemics a la llista d’amics.',
	'NOT_ADDED_FRIENDS_SELF'		=> 'No podeu afegir-vos a la llista d’amics.',
	'NOT_ADDED_FOES_MOD_ADMIN'		=> 'No podeu afegir administradors o moderadors a la llista d’enemics.',
	'NOT_ADDED_FOES_ANONYMOUS'		=> 'No podeu afegir l’usuari anònim a la llista d’enemics.',
	'NOT_ADDED_FOES_BOTS'			=> 'No podeu afegir robots a la llista d’enemics.',
	'NOT_ADDED_FOES_FRIENDS'		=> 'No podeu afegir usuaris de la llista d’amics a la llista d’enemics.',
	'NOT_ADDED_FOES_SELF'			=> 'No podeu afegir-vos a la llista d’enemics.',
	'NOT_AGREE'						=> 'No accepto aquestes condicions',
	'NOT_ENOUGH_SPACE_FOLDER'		=> 'La carpeta de destí “%s” és plena. L’acció sol·licitada no s’ha dut a terme.',
	'NOT_MOVED_MESSAGE'				=> 'Actualment teniu 1 missatge privat retingut perquè la carpeta és plena.',
	'NOT_MOVED_MESSAGES'			=> 'Actualment teniu %d missatges privats retinguts perquè la carpeta és plena.',
	'NO_ACTION_MODE'				=> 'No s’ha especificat cap acció per al missatge.',
	'NO_AUTHOR'						=> 'No s’ha especificat cap autor per aquest missatge',
	'NO_AVATAR_CATEGORY'			=> 'Cap',

	'NO_AUTH_DELETE_MESSAGE'		=> 'No esteu autoritzat a eliminar missatges privats.',
	'NO_AUTH_EDIT_MESSAGE'			=> 'No esteu autoritzat a editar missatges privats.',
	'NO_AUTH_FORWARD_MESSAGE'		=> 'No esteu autoritzat a reenviar missatges privats.',
	'NO_AUTH_GROUP_MESSAGE'			=> 'No esteu autoritzat a enviar missatges privats a grups.',
	'NO_AUTH_PASSWORD_REMINDER'		=> 'No esteu autoritzat a sol·licitar una contrasenya nova.',
	'NO_AUTH_READ_HOLD_MESSAGE'		=> 'No esteu autoritzat a llegir missatges privats retinguts.',
	'NO_AUTH_READ_MESSAGE'			=> 'No esteu autoritzat a llegir missatges privats.',
	'NO_AUTH_READ_REMOVED_MESSAGE'	=> 'No podeu llegir aquest missatge privat perquè l’autor l’ha eliminat.',
	'NO_AUTH_SEND_MESSAGE'			=> 'No esteu autoritzat a enviar missatges privats.',
	'NO_AUTH_SIGNATURE'				=> 'No esteu autoritzat a definir una signatura.',

	'NO_BCC_RECIPIENT'			=> 'Cap',
	'NO_BOOKMARKS'				=> 'No teniu definides adreces d’interès.',
	'NO_BOOKMARKS_SELECTED'		=> 'No heu seleccionat cap adreça d’interès.',
	'NO_EDIT_READ_MESSAGE'		=> 'No podeu editar el missatge privat perquè ja ha estat llegit.',
	'NO_EMAIL_USER'				=> 'No s’ha trobat la informació d’adreça electrònica/nom d’usuari tramesa.',
	'NO_FOES'					=> 'Actualment no hi ha definit cap enemic',
	'NO_FRIENDS'				=> 'Actualment no hi ha definit cap amic',
	'NO_FRIENDS_OFFLINE'		=> 'No hi ha amics desconnectats',
	'NO_FRIENDS_ONLINE'			=> 'No hi ha amics connectats',
	'NO_GROUP_SELECTED'			=> 'No heu especificat cap grup.',
	'NO_IMPORTANT_NEWS'			=> 'No hi ha avisos importants.',
	'NO_MESSAGE'				=> 'No s’ha trobat el missatge privat.',
	'NO_NEW_FOLDER_NAME'		=> 'Heu d’especificar un nom de carpeta nou.',
	'NO_NEWER_PM'				=> 'No hi ha missatges més recents.',
	'NO_OLDER_PM'				=> 'No hi ha missatges més antics.',
	'NO_PASSWORD_SUPPLIED'		=> 'No podeu iniciar la sessió sense una contrasenya.',
	'NO_RECIPIENT'				=> 'No heu definit cap destinatari.',
	'NO_RULES_DEFINED'			=> 'No heu definit cap regla.',
	'NO_SAVED_DRAFTS'			=> 'No hi ha cap esborrany desat.',
	'NO_TO_RECIPIENT'			=> 'Cap',
	'NO_WATCHED_FORUMS'			=> 'No esteu subscrit a cap fòrum.',
	'NO_WATCHED_SELECTED'		=> 'No heu seleccionat cap tema o fòrum al qual estigueu subscrit.',
	'NO_WATCHED_TOPICS'			=> 'No esteu subscrit a cap tema.',

	'PASS_TYPE_ALPHA_EXPLAIN'	=> 'La contrasenya ha de tenir entre %1$d i %2$d caràcters i ha de contenir majúscules, minúscules i números.',
	'PASS_TYPE_ANY_EXPLAIN'		=> 'Ha de tenir una longitud d’entre %1$d i %2$d caràcters.',
	'PASS_TYPE_CASE_EXPLAIN'	=> 'La contrasenya ha de tenir entre %1$d i %2$d caràcters i ha de contenir majúscules, minúscules.',
	'PASS_TYPE_SYMBOL_EXPLAIN'	=> 'La contrasenya ha de tenir entre %1$d i %2$d caràcters i ha de contenir majúscules, minúscules, números i signes.',
	'PASSWORD'					=> 'Contrasenya',
	'PASSWORD_ACTIVATED'		=> 'S’ha activat la vostra contrasenya nova.',
	'PASSWORD_UPDATED'			=> 'S’ha enviat una contrasenya nova a l’adreça electrònica amb la que us vau registrar.',
	'PERMISSIONS_RESTORED'		=> 'S’han restaurat els permisos originals correctament.',
	'PERMISSIONS_TRANSFERRED'	=> 'S’han transferit els permisos de <strong>%s</strong>, ara podeu navegar els fòrums amb els permisos d’aquest usuari.<br />Tingueu en compte que els permisos d’administrador no s’han transferit. Podeu retornar als vostres permisos en qualsevol moment.',
	'PM_DISABLED'				=> 'S’ha inhabilitat la missatgeria privada en aquests fòrums.',
	'PM_FROM'					=> 'De',
	'PM_FROM_REMOVED_AUTHOR'	=> 'Aquest missatge l’ha enviat un usuari que ja no està registrat.',
	'PM_ICON'					=> 'Icona MP',
	'PM_INBOX'					=> 'Safata d’entrada',
	'PM_NO_USERS'				=> 'Els usuaris que heu intentat afegir no existeixen.',
	'PM_OUTBOX'					=> 'Safata de sortida',
	'PM_SENTBOX'				=> 'Missatges enviats',
	'PM_SUBJECT'				=> 'Assumpte del missatge',
	'PM_TO'						=> 'Envia’l a',
	'PM_USERS_REMOVED_NO_PM'	=> 'No s’han pogut afegir alguns usuaris perquè han inhabilitat la recepció de missatges privats.',
	'POPUP_ON_PM'				=> 'Mostra una finestra emergent quan rebi un missatge privat nou',
	'POST_EDIT_PM'				=> 'Edició de missatges',
	'POST_FORWARD_PM'			=> 'Reenviament de missatges',
	'POST_NEW_PM'				=> 'Redacció de missatges',
	'POST_PM_LOCKED'			=> 'La missatgeria privada està bloquejada.',
	'POST_PM_POST'				=> 'Cita l’entrada',
	'POST_QUOTE_PM'				=> 'Cita el missatge',
	'POST_REPLY_PM'				=> 'Respon el missatge',
	'PRINT_PM'					=> 'Vista d’impressió',
	'PREFERENCES_UPDATED'		=> 'S’han actualitzat les vostres preferències.',
	'PROFILE_INFO_NOTICE'		=> 'Tingueu en compte que aquesta informació pot ser vista per altres membres. Sigueu prudent amb la informació personal que afegiu. Els camps marcats amb un * són obligatoris.',
	'PROFILE_UPDATED'			=> 'S’ha actualitzat el vostre perfil.',

	'RECIPIENT'							=> 'Destinatari',
	'RECIPIENTS'						=> 'Destinataris',
	'REGISTRATION'						=> 'Registre',
	'RELEASE_MESSAGES'					=> '%sAllibera tots els missatges retinguts%s… s’assignaran a les carpetes apropiades si hi ha espai suficient.',
	'REMOVE_ADDRESS'					=> 'Elimina l’adreça',
	'REMOVE_SELECTED_BOOKMARKS'			=> 'Elimina les adreces d’interès seleccionades',
	'REMOVE_SELECTED_BOOKMARKS_CONFIRM'	=> 'Esteu segur que voleu eliminar totes les adreces d’interès seleccionades?',
	'REMOVE_BOOKMARK_MARKED'			=> 'Elimina les adreces d’interès marcades',
	'REMOVE_FOLDER'						=> 'Elimina la carpeta',
	'REMOVE_FOLDER_CONFIRM'				=> 'Esteu segur que voleu eliminar aquesta carpeta?',
	'RENAME'							=> 'Canvia el nom',
	'RENAME_FOLDER'						=> 'Canvia el nom de la carpeta',
	'REPLIED_MESSAGE'					=> 'Missatge respost',
	'REPLY_TO_ALL'						=> 'Respon al remitent i a tots els destinataris.',
	'REPORT_PM'							=> 'Informa del missatge privat',
	'RESIGN_SELECTED'					=> 'Cancel·la l’afiliació al grups seleccionats',
	'RETURN_FOLDER'						=> '%1$sTorna a la carpeta anterior%2$s',
	'RETURN_UCP'						=> '%sTorna al Tauler de control de l’usuari%s',
	'RULE_ADDED'						=> 'S’ha afegit la regla correctament.',
	'RULE_ALREADY_DEFINED'				=> 'Aquesta regla ja està definida.',
	'RULE_DELETED'						=> 'S’ha eliminat la regla correctament.',
	'RULE_NOT_DEFINED'					=> 'No s’ha especificat la regla correctament.',
	'RULE_REMOVED_MESSAGE'				=> 'S’ha eliminat 1 missatge privat a causa dels filtres.',
	'RULE_REMOVED_MESSAGES'				=> 'S’han eliminat %d missatges privats a causa dels filtres.',

	'SAME_PASSWORD_ERROR'		=> 'La contrasenya nova que heu introduït és la mateixa que la vostra contrasenya actual.',
	'SEARCH_YOUR_POSTS'			=> 'Mostra les meves entrades',
	'SEND_PASSWORD'				=> 'Envia’m una contrasenya',
	'SENT_AT'					=> 'Enviat el',			// Used before dates in private messages
	'SHOW_EMAIL'				=> 'Els usuaris poden contactar-me per correu electrònic',
	'SIGNATURE_EXPLAIN'			=> 'La signatura és un bloc de text que es pot afegir a les entrades que feu. Hi ha un límit de %d caràcters.',
	'SIGNATURE_PREVIEW'			=> 'La vostra signatura apareixerà així a les entrades',
	'SIGNATURE_TOO_LONG'		=> 'La vostra signatura és massa llarga.',
	'SORT'						=> 'Ordena',
	'SORT_COMMENT'				=> 'Comentari del fitxer',
	'SORT_DOWNLOADS'			=> 'Baixades',
	'SORT_EXTENSION'			=> 'Extensió',
	'SORT_FILENAME'				=> 'Nom del fitxer',
	'SORT_POST_TIME'			=> 'Data de publicació',
	'SORT_SIZE'					=> 'Mida del fitxer',

	'TIMEZONE'					=> 'Fus horari',
	'TO'						=> 'Destinatari',
	'TOO_MANY_RECIPIENTS'		=> 'Heu provat d’enviar un missatge privat a massa destinataris.',
	'TOO_MANY_REGISTERS'		=> 'Heu excedit el nombre màxim d’intents de registre durant aquesta sessió. Si us plau, torneu a intentar-ho més tard.',

	'UCP'						=> 'Tauler de control de l’usuari',
	'UCP_ACTIVATE'				=> 'Activa el compte',
	'UCP_ADMIN_ACTIVATE'		=> 'Tingueu en compte que haureu d’introduir una adreça electrònica vàlida abans que el vostre compte sigui activat. L’administrador revisarà el vostre compte i si l’aprova rebreu un correu electrònic a l’adreça que heu especificat.',
	'UCP_AIM'					=> 'AOL Instant Messenger',
	'UCP_ATTACHMENTS'			=> 'Fitxers adjunts',
	'UCP_COPPA_BEFORE'			=> 'Abans del %s',
	'UCP_COPPA_ON_AFTER'		=> 'Durant o després del %s',
	'UCP_EMAIL_ACTIVATE'		=> 'Tingueu en compte que haureu d’introduir una adreça electrònica vàlida abans que el vostre compte sigui activat. Rebreu un correu electrònic que conté un enllaç d’activació a l’adreça que heu especificat.',
	'UCP_ICQ'					=> 'Número ICQ',
	'UCP_JABBER'				=> 'Adreça Jabber',

	'UCP_MAIN'					=> 'Principal',
	'UCP_MAIN_ATTACHMENTS'		=> 'Gestió dels fitxers adjunts',
	'UCP_MAIN_BOOKMARKS'		=> 'Gestió de les adreces d’interès',
	'UCP_MAIN_DRAFTS'			=> 'Gestió dels esborranys',
	'UCP_MAIN_FRONT'			=> 'Pàgina principal',
	'UCP_MAIN_SUBSCRIBED'		=> 'Gestió de les subscripcions',

	'UCP_MSNM'					=> 'WL/MSN Messenger',
	'UCP_NO_ATTACHMENTS'		=> 'No heu publicat cap fitxer.',

	'UCP_PREFS'					=> 'Preferències del fòrum',
	'UCP_PREFS_PERSONAL'		=> 'Edició de les preferències globals',
	'UCP_PREFS_POST'			=> 'Edició dels valors per defecte de publicació',
	'UCP_PREFS_VIEW'			=> 'Edició de les opcions de visualització',

	'UCP_PM'					=> 'Missatges privats',
	'UCP_PM_COMPOSE'			=> 'Redacció de missatges',
	'UCP_PM_DRAFTS'				=> 'Gestió dels esborranys de MP',
	'UCP_PM_OPTIONS'			=> 'Regles, carpetes i preferències',
	'UCP_PM_POPUP'				=> 'Missatges privats',
	'UCP_PM_POPUP_TITLE'		=> 'Finestra emergent per a missatges privats',
	'UCP_PM_UNREAD'				=> 'Missatges no llegits',
	'UCP_PM_VIEW'				=> 'Visualització dels missatges',

	'UCP_PROFILE'				=> 'Perfil',
	'UCP_PROFILE_AVATAR'		=> 'Edició de l’avatar',
	'UCP_PROFILE_PROFILE_INFO'	=> 'Edició del perfil',
	'UCP_PROFILE_REG_DETAILS'	=> 'Edició del compte',
	'UCP_PROFILE_SIGNATURE'		=> 'Edició de la signatura',

	'UCP_USERGROUPS'			=> 'Grups d’usuaris',
	'UCP_USERGROUPS_MEMBER'		=> 'Edició de les afiliacions',
	'UCP_USERGROUPS_MANAGE'		=> 'Gestió dels grups',

	'UCP_REGISTER_DISABLE'			=> 'No és possible crear un compte nou actualment.',
	'UCP_REMIND'					=> 'Envia la contrasenya',
	'UCP_RESEND'					=> 'Envia el correu electrònic d’activació',
	'UCP_WELCOME'					=> 'Benvingut al Tauler de control de l’usuari. Des d’aquí podeu visualitzar, actualitzar i fer un seguiment del vostre perfil, preferències, i subscripcions. També podeu enviar missatges a altres usuaris si se’n permet l’ús. Asegureu-vos de llegir els possibles avisos abans de continuar.',
	'UCP_YIM'						=> 'Yahoo Messenger',
	'UCP_ZEBRA'						=> 'Amics i enemics',
	'UCP_ZEBRA_FOES'				=> 'Gestió dels enemics',
	'UCP_ZEBRA_FRIENDS'				=> 'Gestió dels amics',
	'UNDISCLOSED_RECIPIENT'			=> 'Destinatari ocult',
	'UNKNOWN_FOLDER'				=> 'Carpeta desconeguda',
	'UNWATCH_MARKED'				=> 'Cancel·la les subscripcions marcades',
	'UPLOAD_AVATAR_FILE'			=> 'Penja’l des de la meva màquina',
	'UPLOAD_AVATAR_URL'				=> 'Penja’l des d’un URL',
	'UPLOAD_AVATAR_URL_EXPLAIN'		=> 'Introduïu l’URL on està ubicada la imatge. La imatge es copiarà en aquest lloc web.',
	'USERNAME_ALPHA_ONLY_EXPLAIN'	=> 'El nom d’usuari ha de tenir entre %1$d i %2$d caràcters i només es poden utilitzar caràcters alfanumèrics.',
	'USERNAME_ALPHA_SPACERS_EXPLAIN'=> 'El nom d’usuari ha de tenir entre %1$d i %2$d caràcters i només es poden utilitzar caràcters alfanumèrics, espais o els caràcters -+_[]',
	'USERNAME_ASCII_EXPLAIN'		=> 'El nom d’usuari ha de tenir entre %1$d i %2$d caràcters i només es poden utilitzar caràcters ASCII, és a dir sense signes especials.',
	'USERNAME_LETTER_NUM_EXPLAIN'	=> 'El nom d’usuari ha de tenir entre %1$d i %2$d caràcters i només es poden utilitzar lletres i números.',
	'USERNAME_LETTER_NUM_SPACERS_EXPLAIN'=> 'El nom d’usuari ha de tenir entre %1$d i %2$d caràcters i només es poden utilitzar lletres, números, espais o els caràcters -+_[]',
	'USERNAME_CHARS_ANY_EXPLAIN'	=> 'Ha de tenir una longitud d’entre %1$d i %2$d caràcters.',
	'USERNAME_TAKEN_USERNAME'		=> 'El nom d’usuari que heu introduït ja existeix, si us plau trieu un nom d’usuari diferent.',
	'USERNAME_DISALLOWED_USERNAME'	=> 'El nom d’usuari que heu introduït no està permès o conté una paraula no permesa. Si us plau, trieu nom d’usuari diferent.',
	'USER_NOT_FOUND_OR_INACTIVE'	=> 'Els noms d’usuari que heu especificat no s’han pogut trobar o bé són d’usuaris no activats.',

	'VIEW_AVATARS'				=> 'Mostra els avatars',
	'VIEW_EDIT'					=> 'Mostra/Edita',
	'VIEW_FLASH'				=> 'Mostra les animacions Flash',
	'VIEW_IMAGES'				=> 'Mostra les imatges a dintre de les entrades',
	'VIEW_NEXT_HISTORY'			=> 'MP següent de l’historial',
	'VIEW_NEXT_PM'				=> 'MP següent',
	'VIEW_PM'					=> 'Mostra el missatge',
	'VIEW_PM_INFO'				=> 'Detalls del missatge',
	'VIEW_PM_MESSAGE'			=> '1 missatge',
	'VIEW_PM_MESSAGES'			=> '%d missatges',
	'VIEW_PREVIOUS_HISTORY'		=> 'MP precedent de l’historial',
	'VIEW_PREVIOUS_PM'			=> 'MP precedent',
	'VIEW_SIGS'					=> 'Mostra les signatures',
	'VIEW_SMILIES'				=> 'Mostra les emoticones amb imatges',
	'VIEW_TOPICS_DAYS'			=> 'Mostra els temes dels darrers dies',
	'VIEW_TOPICS_DIR'			=> 'Mostra el temes en ordre',
	'VIEW_TOPICS_KEY'			=> 'Mostra els temes ordenats per',
	'VIEW_POSTS_DAYS'			=> 'Mostra les entrades dels darrers dies',
	'VIEW_POSTS_DIR'			=> 'Mostra les entrades en ordre',
	'VIEW_POSTS_KEY'			=> 'Mostra les entrades ordenades per',

	'WATCHED_EXPLAIN'			=> 'A continuació hi ha una llista amb els fòrums i els temes als quals esteu subscrit. Rebreu un avís quan hi hagi entrades noves en qualsevol dels dos. Per cancel·lar la subscripció marqueu el fòrum o el tema i feu clic al botó <em>Cancel·la les subscripcions marcades</em>.',
	'WATCHED_FORUMS'			=> 'Fòrums als quals esteu subscrit',
	'WATCHED_TOPICS'			=> 'Temes als quals esteu subscrit',
	'WRONG_ACTIVATION'			=> 'La clau d’activació que heu proporcionat no coincideix amb cap de les que hi ha a la base de dades.',

	'YOUR_DETAILS'				=> 'La vostra activitat',
	'YOUR_FOES'					=> 'Els vostres enemics',
	'YOUR_FOES_EXPLAIN'			=> 'Per treure noms d’usuari seccioneu-los i feu clic al botó <em>Tramet</em>.',
	'YOUR_FRIENDS'				=> 'Els vostres amics',
	'YOUR_FRIENDS_EXPLAIN'		=> 'Per treure noms d’usuari seccioneu-los i feu clic al botó <em>Tramet</em>.',
	'YOUR_WARNINGS'				=> 'El vostre nivell d’advertiments',

	'PM_ACTION' => array(
		'PLACE_INTO_FOLDER'	=> 'Desplaça’l a la carpeta',
		'MARK_AS_READ'		=> 'Marca’l com a llegit',
		'MARK_AS_IMPORTANT'	=> 'Marca el missatge',
		'DELETE_MESSAGE'	=> 'Elimina el missatge'
	),
	'PM_CHECK' => array(
		'SUBJECT'	=> 'l’assumpte',
		'SENDER'	=> 'el remitent',
		'MESSAGE'	=> 'el missatge',
		'STATUS'	=> 'l’estat del missatge',
		'TO'		=> 'me l’han enviat'
	),
	'PM_RULE' => array(
		'IS_LIKE'		=> 'és similar a',
		'IS_NOT_LIKE'	=> 'no és similar a',
		'IS'			=> 'és',
		'IS_NOT'		=> 'no és',
		'BEGINS_WITH'	=> 'comença amb',
		'ENDS_WITH'		=> 'acaba amb',
		'IS_FRIEND'		=> 'és un amic',
		'IS_FOE'		=> 'és un enemic',
		'IS_USER'		=> 'és un usuari',
		'IS_GROUP'		=> 'és del grup d’usuaris',
		'ANSWERED'		=> 'contestat',
		'FORWARDED'		=> 'reenviat',
		'TO_GROUP'		=> 'al meu grup per defecte',
		'TO_ME'			=> 'a mi'
	),


	'GROUPS_EXPLAIN'	=> 'Els grups d’usuaris permeten als administradors del fòrum gestionar milllor els usuaris. Per defecte se us assignarà a un grup específic (el vostre grup per defecte). Aquest grup determina com apareixeu als altres usuaris, per exemple el color del vostre nom d’usuari, avatar, rang, etc. Si l’administrador ho permet, és possible canviar el vostre grup per defecte. També se us pot assignar a altres grups o permetre que us hi afilieu. Alguns grups poden donar-vos permisos addicionals per veure determinats continguts o augmentar les vostres capacitats en altres àrees.',
	'GROUP_LEADER'		=> 'Grups dels que sou líder',
	'GROUP_MEMBER'		=> 'Grups als que esteu afiliat',
	'GROUP_PENDING'		=> 'Afiliacions pendents',
	'GROUP_NONMEMBER'	=> 'Grups als que no esteu afiliat',
	'GROUP_DETAILS'		=> 'Detalls del grup',

	'NO_LEADER'		=> 'No sou líder de cap grup',
	'NO_MEMBER'		=> 'No esteu afiliats a cap grup',
	'NO_PENDING'	=> 'No teniu cap afiliació pendent',
	'NO_NONMEMBER'	=> 'No hi ha cap grup al qual no estigueu afiliat',
));

?>