<?php
	/**************************************************************************\
	* phpGroupWare - Headlines Administration                                  *
	* http://www.phpgroupware.org                                              *
	* Written by Joseph Engo <jengo@phpgroupware.org>                          *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	/* $Id: editheadline.php,v 1.12.2.1.2.3 2004/01/29 08:46:11 skwashd Exp $ */

	$phpgw_info['flags'] = array(
		'admin_only' => True,
		'currentapp' => 'headlines',
		'nonavbar'   => True,
		'noheader'   => True
	);
	include('../header.inc.php');

	$con = intval(get_var('con', array('GET', 'POST')));
	if (! $con)
	{
		$GLOBALS['phpgw']->redirect($GLOBALS['phpgw']->link('/headlines/admin.php'));
	}

	if ($_POST['submit'])
	{
		if (! $_POST['n_display'])
		{
			$errors[] = lang('You must enter a display');
		}
		else
		{
			$n_display = $GLOBALS['phpgw']->db->db_addslashes($_POST['n_display']);
		}
		
		if (! $_POST['$n_base_url'])
		{
			$errors[] = lang('You must enter a base url');
		}
		else
		{
			if(substr($_POST['n_base_url'], -1) == '/')
			{
				$_POST['n_base_url'] = substr($_POST['n_base_url'], 0 , -1);
			}
			$n_base_url = $GLOBALS['phpgw']->db->db_addslashes($_POST['n_base_url']);
		}
		
		if (! $_POST['n_newsfile'])
		{
			$errors[] = lang('You must enter a news url');
		}
		else
		{
			if(substr($n_newsfile, 0, 1) == '/')
			{
				$_POST['n_newsfile'] = substr($_POST['n_newsfile'], 1);
			}
			$n_newsfile = $GLOBALS['phpgw']->db->db_addslashes($_POST['n_newsfile']);
		}

		if (! intval($_POST['n_cachetime']))
		{
			$errors[] = lang('You must enter the number of minutes between reload');
		}
		else
		{
			$n_cachetime = intval($_POST['n_cachetime']);
		}

		if (! intval($_POST['n_listings']))
		{
			$errors[] = lang('You must enter the number of listings display');
		}
		else
		{
			$n_listings = intval($_POST['n_listings']);
		}

		$GLOBALS['phpgw']->db->query('SELECT display FROM phpgw_headlines_sites'
					. " WHERE base_url='" . strtolower($n_base_url) . "'"
					. " AND newsfile LIKE'"	. $n_newsfile . "'" 
					. ' AND con !=' . $con,__LINE__,__FILE__);
		$GLOBALS['phpgw']->db->next_record();
		if ($GLOBALS['phpgw']->db->f('display'))
		{
			$errors[] = lang('That site has already been entered');
		}

		$GLOBALS['phpgw']->db->query('UPDATE phpgw_headlines_sites SET '
			. " display='$n_display'," 
			. " base_url='$n_base_url',"
			. " newsfile='$n_newsfile',"
			. " lastread=0, newstype='" . $GLOBALS['phpgw']->db->db_addslashes($n_newstype) . "',"
			. " cachetime = $n_cachetime, "
			. " listings = $n_listings "
			. " WHERE con= $con",__LINE__,__FILE__);

		$GLOBALS['phpgw']->redirect($GLOBALS['phpgw']->link('/headlines/admin.php'));
	}
	else
	{
		$GLOBALS['phpgw']->db->query("SELECT * FROM phpgw_headlines_sites WHERE con=$con",__LINE__, __FILE__);
		$GLOBALS['phpgw']->db->next_record();

		$n_display   = $GLOBALS['phpgw']->db->f('display', True);
		$n_base_url  = $GLOBALS['phpgw']->db->f('base_url', True);
		$n_newsfile  = $GLOBALS['phpgw']->db->f('newsfile', True);
		$n_cachetime = $GLOBALS['phpgw']->db->f('cachetime');
		$n_newstype  = $GLOBALS['phpgw']->db->f('newstype', True);
		$n_listings  = $GLOBALS['phpgw']->db->f('listings');
	}

	$GLOBALS['phpgw']->common->phpgw_header();
	echo parse_navbar();

	// This is done for a reason (jengo)
	$GLOBALS['phpgw']->template->set_root($GLOBALS['phpgw']->common->get_tpl_dir('headlines'));

	$GLOBALS['phpgw']->template->set_file(array(
		'admin_form' => 'admin_form.tpl'
	));
	$GLOBALS['phpgw']->template->set_block('admin_form','form');
	$GLOBALS['phpgw']->template->set_block('admin_form','buttons');

	if (is_array($errors))
	{
		$GLOBALS['phpgw']->template->set_var('messages',$GLOBALS['phpgw']->common->error_list($errors));
	}

	$GLOBALS['phpgw']->template->set_var('title',lang('Headlines Administration'));
	$GLOBALS['phpgw']->template->set_var('lang_header',lang('Update headline'));
	$GLOBALS['phpgw']->template->set_var('th_bg',$phpgw_info['theme']['th_bg']);
	$GLOBALS['phpgw']->template->set_var('row_on',$phpgw_info['theme']['row_on']);
	$GLOBALS['phpgw']->template->set_var('row_off',$phpgw_info['theme']['row_off']);
	$GLOBALS['phpgw']->template->set_var('lang_display',lang('Display'));
	$GLOBALS['phpgw']->template->set_var('lang_base_url',lang('Base URL'));
	$GLOBALS['phpgw']->template->set_var('lang_news_file',lang('News File'));
	$GLOBALS['phpgw']->template->set_var('lang_minutes',lang('Minutes between refresh'));
	$GLOBALS['phpgw']->template->set_var('lang_listings',lang('Listings Displayed'));
	$GLOBALS['phpgw']->template->set_var('lang_type',lang('News Type'));
	$GLOBALS['phpgw']->template->set_var('lang_button',lang('Update'));

	$GLOBALS['phpgw']->template->set_var('input_display','<input name="n_display" value="' . htmlentities($n_display) . '" size="40">');
	$GLOBALS['phpgw']->template->set_var('input_base_url','<input name="n_base_url" value="' . htmlentities($n_base_url) . '" size="40">');
	$GLOBALS['phpgw']->template->set_var('input_news_file','<input name="n_newsfile" value="' . htmlentities($n_newsfile) . '" size="40">');
	$GLOBALS['phpgw']->template->set_var('input_minutes','<input name="n_cachetime" value="' . $n_cachetime . '" size="4">');
	$GLOBALS['phpgw']->template->set_var('input_listings','<input name="n_listings" value="' . $n_listings . '" size="2">');

	$news_type = array('rdf','fm','lt','sf','rdf-chan');
	while (list(,$item) = each($news_type))
	{
		$_select .= '<option value="' . $item . '"' . ($n_newstype == $item?' selected':'')
					. '>' . $item . '</option>';
	}
	$GLOBALS['phpgw']->template->set_var('input_type','<select name="n_newstype">' . $_select . '</select>');

	$GLOBALS['phpgw']->template->set_var('action_url',$GLOBALS['phpgw']->link('/headlines/editheadline.php','con=' . $con));

	$GLOBALS['phpgw']->template->parse('buttons','buttons');
	$GLOBALS['phpgw']->template->pfp('out','form');

	$GLOBALS['phpgw']->common->phpgw_footer();
?>
