<?php
	/***************************************************************************\
	* phpGroupWare - QMailLDAP                                                  *
	* http://www.phpgroupware.org                                               *
	* Written by : Lars Kneschke [lkneschke@linux-at-work.de]                   *
	* -------------------------------------------------------                   *
	* This program is free software; you can redistribute it and/or modify it   *
	* under the terms of the GNU General Public License as published by the     *
	* Free Software Foundation; either version 2 of the License, or (at your    *
	* option) any later version.                                                *
	\***************************************************************************/
	/* $Id: class.uiuserdata.inc.php,v 1.6.4.5 2005/03/02 22:51:49 ceb Exp $ */

	class uiuserdata
	{
		var $public_functions = array
		(
			'editUserData'	=> True,
			'saveUserData'	=> True
		);

		function uiuserdata()
		{
			$this->boqmailldap	= CreateObject('qmailldap.boqmailldap');
		}

		function display_app_header()
		{
			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();
		}

		function editUserData($_useCache = False)
		{
			$account_id = get_var('account_id',array('GET'));

			$this->display_app_header();
			$this->translate();
			$GLOBALS['phpgw_info']['flags']['app_header'] = lang('qmailldap') . ': ' . lang('edit user data');

			$GLOBALS['phpgw']->template->set_file(array('editUserData' => 'edituserdata.tpl'));
			$GLOBALS['phpgw']->template->set_block('editUserData','form','form');
			$GLOBALS['phpgw']->template->set_block('editUserData','link_row','link_row');
			$GLOBALS['phpgw']->template->set_var('link_back',$GLOBALS['phpgw']->link('/admin/accounts.php'));

			$linkData = array
			(
				'menuaction'	=> 'qmailldap.uiuserdata.saveUserData',
				'account_id'	=> $account_id
			);
			$GLOBALS['phpgw']->template->set_var('form_action',$GLOBALS['phpgw']->link('/index.php',$linkData));
			
			// only when we show a existing user
			if($userData = $this->boqmailldap->getUserData($account_id, $_useCache))
			{
				if ($userData['mailAlternateAddress'] != '')
				{
					$options_mailAlternateAddress = '<select size="6" name="mailAlternateAddress">' . "\n";
					for ($i=0;$i < count($userData['mailAlternateAddress']); $i++)
					{
						$options_mailAlternateAddress .= '<option value="' . $i . '">' . $userData['mailAlternateAddress'][$i] . '</option>' . "\n";
					}
					$options_mailAlternateAddress .= '</select>' . "\n";
				}
				else
				{
					$options_mailAlternateAddress = lang('no alternate email address');
				}

				$GLOBALS['phpgw']->template->set_var('mailLocalAddress',$userData['mailLocalAddress']);
				$GLOBALS['phpgw']->template->set_var('mailAlternateAddress','');
				$GLOBALS['phpgw']->template->set_var('options_mailAlternateAddress',$options_mailAlternateAddress);
				$GLOBALS['phpgw']->template->set_var('mailRoutingAddress',$userData['mailRoutingAddress']);
				$GLOBALS['phpgw']->template->set_var('selected_'.$userData['qmailDotMode'],'selected');
				$GLOBALS['phpgw']->template->set_var('deliveryProgramPath',$userData['deliveryProgramPath']);
				
				$GLOBALS['phpgw']->template->set_var('uid',rawurlencode($_accountData['dn']));
				$GLOBALS['phpgw']->template->set_var('account_checked',($userData['accountStatus'] == 'active'?'checked':''));	
				$GLOBALS['phpgw']->template->set_var('deliver_checked',($_accountData['deliverExtern'] == 'active'?'checked':''));
			}
			else
			{
				$GLOBALS['phpgw']->template->set_var('mailLocalAddress','');
				$GLOBALS['phpgw']->template->set_var('mailAlternateAddress','');
				$GLOBALS['phpgw']->template->set_var('mailRoutingAddress','');
				$GLOBALS['phpgw']->template->set_var('options_mailAlternateAddress',lang('no alternate email address'));
				$GLOBALS['phpgw']->template->set_var('account_checked','');
			}
		
			// create the menu on the left, if needed		
			$menuClass = CreateObject('admin.uimenuclass');
			$GLOBALS['phpgw']->template->set_var('rows',$menuClass->createHTMLCode('edit_user'));
			$GLOBALS['phpgw']->template->pfp('out','form');
		}

		function saveUserData()
		{
			$formData = array
			(
				'mailLocalAddress'				=> $_POST['mailLocalAddress'],
				'mailRoutingAddress'			=> $_POST['mailRoutingAddress'],
				'add_mailAlternateAddress'		=> $_POST['mailAlternateAddressInput'],
				'remove_mailAlternateAddress'	=> $_POST['mailAlternateAddress'],
				'qmailDotMode'					=> $_POST['qmailDotMode'],
				'deliveryProgramPath'			=> $_POST['deliveryProgramPath'],
				'accountStatus'					=> $_POST['accountStatus']
			);

			if($_POST['save'])
			{
				$bo_action='save';
			}
			elseif($_POST['add_mailAlternateAddress'])
			{
				$bo_action='add_mailAlternateAddress';
			}
			elseif($_POST['remove_mailAlternateAddress'])
			{
				$bo_action='remove_mailAlternateAddress';
			}
			$this->boqmailldap->saveUserData($_GET['account_id'], $formData, $bo_action);

			if ($bo_action == 'save')
			{
				// read date fresh from ldap storage
				$this->editUserData();
			}
			else
			{
				// use cached data
				$this->editUserData(True);
			}
		}

		function translate()
		{
			$GLOBALS['phpgw']->template->set_var('th_bg',$GLOBALS['phpgw_info']['theme']['th_bg']);
			$GLOBALS['phpgw']->template->set_var('tr_color1',$GLOBALS['phpgw_info']['theme']['row_on']);
			$GLOBALS['phpgw']->template->set_var('tr_color2',$GLOBALS['phpgw_info']['theme']['row_off']);
			$GLOBALS['phpgw']->template->set_var('lang_add',lang('add'));
			$GLOBALS['phpgw']->template->set_var('lang_save',lang('save'));
			$GLOBALS['phpgw']->template->set_var('lang_done',lang('done'));
			$GLOBALS['phpgw']->template->set_var('lang_remove',lang('remove'));
			$GLOBALS['phpgw']->template->set_var('lang_advanced_options',lang('advanced options'));
			$GLOBALS['phpgw']->template->set_var('lang_qmaildotmode',lang('qmaildotmode'));
			$GLOBALS['phpgw']->template->set_var('lang_default',lang('default'));
			$GLOBALS['phpgw']->template->set_var('lang_deliveryProgramPath',lang('deliveryProgramPath'));

			$GLOBALS['phpgw']->template->set_var('lang_email_config',lang('edit email settings'));
			$GLOBALS['phpgw']->template->set_var('lang_emailAddress',lang('email address'));
			$GLOBALS['phpgw']->template->set_var('lang_emailaccount_active',lang('email account active'));
			$GLOBALS['phpgw']->template->set_var('lang_mailAlternateAddress',lang('alternate email address'));
			$GLOBALS['phpgw']->template->set_var('lang_mailRoutingAddress',lang('forward emails to'));
			$GLOBALS['phpgw']->template->set_var('lang_forward_also_to',lang('forward also to'));
			$GLOBALS['phpgw']->template->set_var('lang_deliver_extern',lang('deliver extern'));
			$GLOBALS['phpgw']->template->set_var('lang_edit_email_settings',lang('edit email settings'));
		}
	}
?>
