<?

/**************************************************************************
 * Things to click on.
 *
 * Copyright (C) 2001, Matthew Palmer.  Released under the GPL version 2.
 * You should have received a copy of this licence with this software, if not
 * see http://www.fsf.org/copyleft/gpl.html for a full copy of the licence.
 */

// $Id: button.inc,v 1.3 2001/12/31 03:54:28 mjp16 Exp $

/* A button which, when clicked, will submit a form with a bunch of hidden
 * elements.  Amongst those will be one called 'action' which should be used
 * to work out what to do.  You can also specify extra HTML code to included
 * in the form.  This should be hidden form elements only.
 * $label is the text which will be on the button, and $file is the file
 * which will be handed the form data.
 */
function action_button($action, $label, $file, $extras = NULL)
{
	$retval = form_header($file);
	$retval .= form_hidden("action", $action);
	$retval .= form_submit($label);
	if ($extras != NULL) {
		$retval .= $extras;
	}
	$retval .= form_footer();
		
	return $retval;
}

/* A button which, when clicked, will run a script.  You have to write the
 * script.
 * Common example: to close a window, use
 * echo script_button("javascript:window.close()", "Close Window");
 */
function script_button($script, $label)
{
	$retval = form_header("");
	$retval .= form_button($label, "onClick=\"$script\"");
	$retval .= form_footer();

	return $retval;
}

/* A generalised button.  You provide an associative array of values which
 * will be the hidden attributes of the button or a string of HTML code
 * which will form the body of the button, as well as the target file and
 * the button label.
 */
function general_button($file, $label, $values)
{
	$retval = form_header($file);
	
	if (is_array($values)) {
		foreach ($values as $tag => $val) {
			$retval .= form_hidden($tag, $val);
		}
	} else {
		$retval .= $values;
	}
	$retval .= form_submit($label);
	$retval .= form_footer();
	
	return $retval;
}

?>
