<?php

/**************************************************************************
 * A textbox form element.
 *
 * Copyright (C) 2001, Matthew Palmer.  Released under the GPL version 2.
 * You should have received a copy of this licence with this software, if not
 * see http://www.fsf.org/copyleft/gpl.html for a full copy of the licence.
 */

// $Id: textbox.inc,v 1.1.1.1 2001/12/30 02:39:25 mjp16 Exp $

require_once("lib/form/element.inc");
 
class formTextbox extends formElement
{
	var $length, $maxlength, $value;

	function formTextbox($name) {
		parent::formElement($name);
		$this->value = parent::value();
	}

	function setValue($value) {
		$this->value = $value;
	}

	function setDefault($val) {
		if (!$this->value) {
			$this->value = $value;
		}
	}

	function setSize($len, $maxlen = NULL) {
		if ($maxlen == NULL) {
			$maxlen = $len;
		}
		$this->maxlength = $maxlen;
		$this->length = $len;
	}

	function getVal() {
		return $this->value;
	}

	function HTML() {
		$element = parent::HTML();
		$retval = "<input type=\"text\" value=\"$this->value\"";
		if ($this->maxlength) {
			$retval .= " size=\"$this->maxlength\"";
		}
		if ($this->length) {
			$retval .= " maxlength=\"$this->length\"";
		}
		$retval .= "$element>\n";
	
		return $retval;
	}
}

?>
