# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Vollmert. All Rights Reserved.
# Portions Copyright (c) 2005 Lukas Lalinsky. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Robert Vollmert, Robert Kaye, Lukas Lalinsky
#
#
# ***** END LICENSE BLOCK *****

import wx
import wx.lib.hyperlink as hl

from page import Page
from picard.ui import images

class AboutPage(Page):

    name = N_("About")

    def __init__(self, parent, config):
        Page.__init__(self, parent, config)

        mainSizer = wx.BoxSizer(wx.HORIZONTAL)
        
        sizer = wx.BoxSizer(wx.VERTICAL)
        
        title = wx.StaticText(self, wx.ID_ANY, "MusicBrainz Picard", style=wx.ALIGN_CENTER_HORIZONTAL)
        font = title.GetFont()
        font.SetPointSize((font.GetPointSize() * 5) / 3)
        font.SetWeight(wx.BOLD)
        title.SetFont(font)
        
        extList = self.config.getTunePimp().getSupportedExtensions()
        extListStr = ""
        while len(extList) > 0:
            extListStr += "\n" + ", ".join(extList[:7])
            extList = extList[7:]
        
        text = _("Version %s\n"
                 "\n"
                 "(c) 2004 Robert Kaye and others\n"
                 "http://musicbrainz.org/\n"
                 "\n"
                 "(c) 2004 Real Networks Helix Community\n"
                 "http://helixcommunity.org/\n"
                 "\n"
                 "This application was made possible\n"
                 "by a Helix Community grant.\n"
                 "\n"
                 "Supported formats: %s") % (config.getAppVersion(), extListStr)
       
        sizer.Add(title, 0, wx.EXPAND)
        sizer.Add(wx.StaticText(self, -1, text, style=wx.ALIGN_CENTER_HORIZONTAL), 1, wx.EXPAND)
                         
        mainSizer.Add(wx.StaticBitmap(self, -1, images.getNoAlbumImageBitmap()), 0, 
                                      wx.LEFT | wx.RIGHT | wx.TOP, 5)
        mainSizer.Add(sizer, 1, wx.EXPAND)
        
        self.content.Add(mainSizer, 1, wx.EXPAND)
        self.Fit()
        
    def save(self):
        pass
