# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Vollmert. All Rights Reserved.
# Portions Copyright (c) 2005 Lukas Lalinsky. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Robert Vollmert, Lukas Lalinsky
#
#
# ***** END LICENSE BLOCK *****

import wx, sys, os
if sys.platform == "win32":
    import win32file
    from win32api import RegOpenKeyEx, RegSetValueEx, RegCloseKey, RegQueryValueEx
    from win32con import KEY_READ, KEY_WRITE, HKEY_CLASSES_ROOT, REG_SZ

from page import Page

class LookupPage(Page):

    name = N_("CD Lookup")
    defaultButtonId = wx.NewId()

    def __init__(self, parent, config):
        Page.__init__(self, parent, config)

        if sys.platform == 'win32':
            box = wx.StaticBox(self, -1, _("CD-ROM drive to use for lookups"))
        else:            
            box = wx.StaticBox(self, -1, _("CD-ROM drive path to use for lookups"))
        sizer = wx.StaticBoxSizer(box, wx.VERTICAL)
        
        if sys.platform == 'win32':
            drives = self.getCDROMDrives()
            index = -1
            try:
                index = drives.index(self.config.settingCDLookupDevice)
            except:
                pass

            self.driveChoice = wx.Choice(self, choices=drives)
            if index != -1:
                self.driveChoice.SetSelection(index)

            self.autoLookupButton = wx.Button(self, self.defaultButtonId, 
                                              _("Launch MB Tagger automatically for inserted Audio CDs"))

            sizer.Add(self.driveChoice, 0, wx.ALL, 5)
            sizer.Add(self.autoLookupButton, 0, wx.ALL, 5)

            wx.EVT_BUTTON(self, self.defaultButtonId, self.OnDefault)
        else:
            self.driveEdit = wx.TextCtrl(self, -1, value=self.config.settingCDLookupDevice)
            sizer.Add(self.driveEdit, 0, wx.LEFT | wx.RIGHT, 40)

        self.content.Add(sizer, 0, wx.EXPAND)
        self.Fit()

    def save(self):
        if sys.platform == 'win32':
            self.config.settingCDLookupDevice = self.driveChoice.GetStringSelection()
        else:
            self.config.settingCDLookupDevice = self.driveEdit.GetValue()


    def getCDROMDrives(self):
        drives = []
        mask = win32file.GetLogicalDrives()
        for i in xrange(26):
            if mask >> i & 1:
                drive = unicode(chr(i + ord('A'))) + u":\\"
                if win32file.GetDriveType(drive) == win32file.DRIVE_CDROM:
                    drives.append(drive)

        return drives

    def OnDefault(self, event):
   
        try:
            self.handle = RegOpenKeyEx(HKEY_CLASSES_ROOT,"AudioCD\\shell\\play\\command",0,KEY_READ|KEY_WRITE)
            RegSetValueEx(self.handle, "", 0, REG_SZ, os.path.abspath(sys.argv[0])+ " lookup")
            RegCloseKey(self.handle)
        except:
            dlg = wx.MessageDialog(self, _("Failed to set the proper registy values to " 
                                           "enable launching the tagger after CD insertion. "), 
                                         _("Default CD setting failed"), wx.OK)
            dlg.ShowModal()
