# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Vollmert. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Robert Vollmert
#
#
# ***** END LICENSE BLOCK *****

import wx
from controls import HostCtrl
from page import Page

class ProxyPage(Page):

    name = N_("Web Proxy")

    def __init__(self, parent, config):
        Page.__init__(self, parent, config)

        box = wx.StaticBox(self, -1, _("Web Proxy"))
        sizer = wx.StaticBoxSizer(box, wx.VERTICAL)
        
        self.useProxy = wx.CheckBox(self, -1, _("Use proxy server to access the Internet"))
        self.useProxy.SetValue(self.config.settingUseProxyServer)
        self.Bind(wx.EVT_CHECKBOX, self.onCheck, self.useProxy)
        
        self.host = HostCtrl(self, -1,
                             hostdesc=_("Proxy server to use") + ":",
                             portdesc=_("Proxy port") + ":",
                             host=self.config.settingProxyServer, port=self.config.settingProxyServerPort)
        self.host.Enable(self.config.settingUseProxyServer)

        sizer.Add(self.useProxy, 0, wx.EXPAND | wx.ALL, 5)
        sizer.Add(self.host, 0, wx.EXPAND | wx.ALL, 5)
        
        self.content.Add(sizer, 0, wx.EXPAND)
        self.Fit()

    def onCheck(self, event):
        self.host.Enable(event.IsChecked())
        
    def save(self):
        self.config.settingUseProxyServer = self.useProxy.GetValue()
        self.config.settingProxyServer, self.config.settingProxyServerPort = self.host.GetValue()

