# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Kaye. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED,G AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Robert Kaye
#
#
# ***** END LICENSE BLOCK *****
import wx, sys, images
from picard import events
from picard.browser import filelookup

class Toolbar(object):

    openFileId = wx.NewId()
    openDirId = wx.NewId()
    optionsId = wx.NewId()
    lookupId = wx.NewId()
    saveId = wx.NewId()
    submitId = wx.NewId()
    analyzeId = wx.NewId()
    clusterId = wx.NewId()
    removeId = wx.NewId()
    listenId = wx.NewId()
    searchEditId = wx.NewId()
    searchButtonId = wx.NewId()

    def __init__(self, frame, config, tb):
        
        self.frame = frame
        self.config = config
        self.tb = tb

        tb.SetToolBitmapSize((24,24))

        tb.AddSimpleTool(self.openFileId, images.getToolbarOpenBitmap(), 
                   shortHelpString=_("Add files..."))
        tb.AddTool(self.openDirId, images.getToolbarOpenDirBitmap(),
                   shortHelpString=_("Add directory..."))
        tb.AddSeparator()
        tb.AddTool(self.optionsId, images.getToolbarOptionsBitmap(),
                   shortHelpString=_("Edit options..."))
        tb.AddSeparator()
        tb.AddTool(self.lookupId, images.getToolbarLookupBitmap(),
                   shortHelpString=_("Lookup CD"))
        tb.AddSeparator()
        tb.AddTool(self.saveId, images.getToolbarSaveBitmap(),
                   shortHelpString=_("Save track/album"))
        tb.AddTool(self.submitId, images.getToolbarSubmitBitmap(),
                   shortHelpString=_("Submit tagged information to MusicBrainz"))
        tb.AddSeparator()
        tb.AddTool(self.analyzeId, images.getToolbarAnalyzeBitmap(),
                   shortHelpString=_("Analyze"))
        tb.AddTool(self.clusterId, images.getToolbarClusterBitmap(),
                   shortHelpString=_("Cluster"))
        tb.AddSeparator()
        tb.AddTool(self.removeId, images.getToolbarRemoveBitmap(),
                   shortHelpString=_("Remove track/album"))
        tb.AddSeparator()
        tb.AddTool(self.listenId, images.getToolbarListenBitmap(),
                   shortHelpString=_("Listen to track"))

        self.searchEdit = wx.TextCtrl(tb, self.searchEditId, style=wx.TE_PROCESS_ENTER)
        self.searchChoice = wx.Choice(tb, wx.NewId(),
                                      choices=[_("Artists"),_("Albums"),_("Tracks")])
        self.searchButton = wx.Button(tb, self.searchButtonId, _("Search"))
        self.searchChoice.SetSelection(0)

        tb.AddSeparator()
        tb.AddControl(self.searchEdit)
        tb.AddControl(wx.StaticText(tb, -1, " "))
        tb.AddControl(self.searchChoice)
        tb.AddControl(wx.StaticText(tb, -1, " "))
        tb.AddControl(self.searchButton)

        tb.Realize()

        wx.EVT_TOOL(self.frame, self.optionsId, self.frame.OnOptions)
        wx.EVT_TOOL(self.frame, self.openDirId, self.frame.OnAddDir)
        wx.EVT_TOOL(self.frame, self.openFileId, self.frame.OnAddFile)
        wx.EVT_TOOL(self.frame, self.clusterId, self.OnCluster)
        wx.EVT_TOOL(self.frame, self.lookupId, self.frame.OnLookupCD)
        wx.EVT_TOOL(self.frame, self.removeId, self.frame.OnRemoveButton)
        wx.EVT_TOOL(self.frame, self.saveId, self.frame.OnSaveButton)
        wx.EVT_TOOL(self.frame, self.submitId, self.frame.OnSubmit)
        wx.EVT_TOOL(self.frame, self.analyzeId, self.frame.OnAnalyzeButton)
        wx.EVT_BUTTON(self.frame, self.searchButtonId, self.OnSearchButton)
        wx.EVT_TEXT_ENTER(self.frame, self.searchEditId, self.OnSearchButton)
        
        self.enableListen(False)
        self.enableCluster(False)
        self.enableSubmit(False)
        self.enableAnalyze(False)

        self.config.setToolbar(self)

    def OnCluster(self, event):
	"""The user has clicked the 'cluster' icon"""

        wx.PostEvent(self.frame, events.ClusterUnmatchedFilesEvent(self.config.persistClusterThreshold))
        wx.WakeUpIdle()

    def isRemoveEnabled(self):
        return self.tb.GetToolEnabled(self.removeId)

    def isSaveEnabled(self):
        return self.tb.GetToolEnabled(self.saveId)

    def isClusterEnabled(self):
        return self.tb.GetToolEnabled(self.clusterId)

    def isSubmitEnabled(self):
        return self.tb.GetToolEnabled(self.submitId)

    def enableSave(self, state):
	"""Enable or disable the 'save' button

	Only called by the album panel."""

        self.tb.EnableTool(self.saveId, state)

    def enableAnalyze(self, state):
	"""Enable or disable the 'remove' button

	Only called by the album panel."""

        if self.config.disableFingerprinting:
            state = False
        self.tb.EnableTool(self.analyzeId, state)

    def enableRemove(self, state):
	"""Enable or disable the 'remove' button

	Only called by the album panel."""

        self.tb.EnableTool(self.removeId, state)

    def enableListen(self, state):
	"""Enable or disable the 'listen' button

	Initialised to 'disabled', then never changed."""

        self.tb.EnableTool(self.listenId, state)

    def enableCluster(self, state):
	"""Enable or disable the 'cluster' button

	Called by the parent frame."""

        self.tb.EnableTool(self.clusterId, state)

    def enableSubmit(self, state):
	"""Enable or disable the 'submit' button

	Initialised to 'disabled', then never changed."""

        self.tb.EnableTool(self.submitId, state)

    def OnSearchButton(self, event):

        query = self.searchEdit.GetValue()
        choice = self.searchChoice.GetStringSelection()
        if not choice or not query:
            return

        self.searchEdit.SetValue("")
        lookup = filelookup.FileLookup(self.frame, self.config.settingServer, 
                                       self.config.settingServerPort, 
                                       self.frame.getTaggerPort())
        if choice == _("Artists"):
            lookup.artistSearch(query)
            return
        if choice == _("Albums"):
            lookup.albumSearch(query)
            return
        if choice == _("Tracks"):
            lookup.trackSearch(query)
            return
