/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment text example
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#include <pgm/pgm.h>

static void
key_press_event_cb (PgmViewport *viewport,
                    PgmEventKey *event,
                    gpointer data)
{
  gchar buffer[7];
  gint len;
  guint32 unicode;

  unicode = pgm_keyval_to_unicode (event->keyval);
  len = g_unichar_to_utf8 (unicode, buffer);
  buffer[len] = '\0';
  g_print ("keyval:0x%x  ucs:%d  char:'%s'\n", event->keyval, unicode, buffer);
}

int
main (int argc, char *argv[])
{
  const gchar *description =
    "<b>PgmText</b> is a drawable displaying a <u>text</u> with support for "
    "multiple lines, <i><b>markups</b> and several</i> properties.";

  PgmViewport *viewport = NULL;
  PgmCanvas *canvas;
  PgmDrawable *txt;

  /* Init */
  pgm_init (&argc, &argv);

  /* OpenGL viewport creation */
  pgm_viewport_factory_make ("opengl", &viewport);
  if (!viewport)
    {
      g_print ("Cannot create the 'opengl' viewport\n");
      return -1;
    }
  pgm_viewport_set_title (viewport, "Text");

  /* Text creation */
  txt = pgm_text_new (NULL);
  pgm_text_set_markup (PGM_TEXT (txt), description);
  pgm_text_set_font_height (PGM_TEXT (txt), 0.12f);
  pgm_drawable_set_size (txt, 1.0f, 1.0f);
  pgm_drawable_set_position (txt, 1.5f, 1.0f, 0.0f);
  pgm_drawable_set_fg_color (txt, 240, 240, 240, 255);
  pgm_drawable_set_bg_color (txt, 20, 20, 20, 255);
  pgm_drawable_show (txt);

  /* Canvas handling */
  canvas = pgm_canvas_new ();
  pgm_viewport_set_canvas (viewport, canvas);
  pgm_canvas_add (canvas, PGM_DRAWABLE_MIDDLE, txt);

  /* Main loop */
  g_signal_connect (G_OBJECT (viewport), "key-press-event",
                    G_CALLBACK (key_press_event_cb), NULL);
  g_signal_connect (G_OBJECT (viewport), "delete-event",
                    G_CALLBACK (pgm_main_quit), NULL);
  pgm_viewport_show (viewport);
  pgm_main ();

  /* Deinit */
  gst_object_unref (canvas);
  gst_object_unref (viewport);
  pgm_deinit ();

  return 0;
}
