/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL ES-CM 1.1 plugin
 *
 * Copyright © 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifndef __PGM_GLES_VIEWPORT_H__
#define __PGM_GLES_VIEWPORT_H__

/* pgmglesviewport.h and pgmglescontext.h/pgmglesdrawable.h include eachother */
typedef struct _PgmGlesViewport      PgmGlesViewport;
typedef struct _PgmGlesViewportClass PgmGlesViewportClass;

#include "pgmglescontext.h"
#include "pgmglesdrawable.h"

G_BEGIN_DECLS

#define PGM_TYPE_GLES_VIEWPORT (pgm_gles_viewport_get_type())
#define PGM_GLES_VIEWPORT(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_GLES_VIEWPORT, PgmGlesViewport))
#define PGM_GLES_VIEWPORT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_GLES_VIEWPORT, PgmGlesViewportClass))
#define PGM_IS_GLES_VIEWPORT(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_GLES_VIEWPORT))
#define PGM_IS_GLES_VIEWPORT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_GLES_VIEWPORT))
#define PGM_GLES_VIEWPORT_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), PGM_TYPE_GLES_VIEWPORT, PgmGlesViewportClass))

/* FIXME: Hardly maintainable */
#define PROPERTY_CHANGED_COUNT 46

typedef void (*PgmGlesDrawableChangedFunc) (PgmGlesDrawable *glesdrawable);

struct _PgmGlesViewport {
  PgmViewport parent;

  /* Canvas bound */
  PgmCanvas *canvas;

  /* PgmGlDrawable layer lists */
  GList  *far_layer;
  GList  *middle_layer;
  GList  *near_layer;
  GMutex *layer_lock;

  /* Update task queue */
  GSList *update_queue;
  GMutex *update_lock;

  /* PgmDrawable/PgmGlesDrawable lookup hash */
  GHashTable *drawable_hash;

  /* OpenGL ES context */
  PgmGlesContext *context;

  /* Signal handler IDs */
  gulong add_handler;
  gulong remove_handler;
  gulong reorder_handler;
  gulong regenerated_handler;

  /* Projection informations */
  gfloat projected_w;
  gfloat projected_h;
  gfloat canvas_w;
  gfloat canvas_h;

  /* Capacities mask */
  gulong capacities;

  /* Drag status */
  gboolean drag_status;
};

struct _PgmGlesViewportClass {
  PgmViewportClass parent_class;

  /* Drawable changed function pointers */
  PgmGlesDrawableChangedFunc changed_func[PROPERTY_CHANGED_COUNT];
};

/* Pixel rectangle */
typedef struct _PgmGlesViewportPixelRectangle {
  guint   x;
  guint   y;
  guint   width;
  guint   height;
  guint8 *pixels;
} PgmGlesViewportPixelRectangle;

GType        pgm_gles_viewport_get_type                   (void) G_GNUC_CONST;

PgmViewport *pgm_gles_viewport_new                        (void);

void         pgm_gles_viewport_register                   (GTypeModule *module);

void         pgm_gles_viewport_flush_update_queue         (PgmGlesViewport *glesviewport);

void         pgm_gles_viewport_update_drawable_projection (PgmGlesViewport *glesviewport);

void         pgm_gles_viewport_connect_changed_callback   (PgmGlesViewport *glesviewport,
                                                           PgmGlesDrawable *glesdrawable);

G_END_DECLS

#endif /* __PGM_GLES_VIEWPORT_H__ */
