# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python binding unit tests
#
# Copyright © 2006, 2007 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

import sys
from pgm_test_case import PgmTestCase
import pgm

class TestViewportFactory(PgmTestCase):

    def setUp(self):
        self.factory = pgm.ViewportFactory('boilerplate')
        PgmTestCase.setUp(self)

    def tearDown(self):
        del self.factory
        PgmTestCase.tearDown(self)

    def test_properties(self):

        description = self.factory.get_description()
        self.failUnless(description)
        self.failUnless(isinstance(description, basestring))

        license = self.factory.get_license()
        self.failUnless(license)
        self.failUnless(isinstance(license, basestring))

        origin = self.factory.get_origin()
        self.failUnless(origin)
        self.failUnless(isinstance(origin, basestring))

        author = self.factory.get_author()
        self.failUnless(author)
        self.failUnless(isinstance(author, basestring))

    def test_create(self):

        viewport = self.factory.create()
        self.failUnless(viewport)
        self.failUnless(isinstance(viewport, pgm.Viewport))

        del viewport
