void main(int argc, array argv)
{
  array files = glob( "?_source_*.c", get_dir( argv[1] ) );

  string result =
    "\n/* Automatically generated by make_sources.pike, do not edit */\n";

  string declrs = "";
  string init = "";
  string make = "";
  string objs = "";
  int first;
  foreach( sort( files ), string f )
  {
    objs += replace( f, ".c", ".o" )+" ";
    sscanf( f, "%*ssource%s.", f );
    f = "source"+f;
    declrs += "extern void "+f+"_init(void);\n";
    declrs += "extern void "+f+"_exit(void);\n";
    declrs += "extern struct source *"+f+"_make(struct svalue *a, INT64 b, INT64 c);\n";
    init += "  "+f+"_init();\n";
    make += "   if( (res="+f+"_make( source, start, len )) ) return res;\n";
  }
  result += declrs+"\n";
  result += "static void sources_init()\n{\n"+init+"}\n\n";
  result += "static void sources_exit()\n{\n"+replace(init,"_init","_exit")
    +"}\n\n";
  result += "static struct source *source_make( struct svalue *source,\n"
            "                                   INT64 start, INT64 len )\n{\n"
            "   struct source *res;\n"
    +make+"   return NULL;\n}\n";

  string x = Stdio.read_bytes( argv[2] );

  if( x != result )
    Stdio.write_file( argv[2], result );
  Stdio.write_file( argv[3], objs );
}
