/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "gpsim_group_ui.h"

#include <qtimer.h>

#include "progs/base/prog_group.h"
#include "progs/gpsim/base/gpsim.h"

//----------------------------------------------------------------------------
GPSim::ConfigWidget::ConfigWidget(const ::Programmer::Group &group, QWidget *parent)
  : ::Programmer::ConfigWidget(group, parent)
{
  uint row = numRows();
  QLabel *label = new QLabel(i18n("Status:"), this);
  addWidget(label, row,row, 0,0);
  _status = new QLabel(this);
  addWidget(_status, row,row, 1,1);

  QTimer::singleShot(0, this, SLOT(updateStatus()));
}

void GPSim::ConfigWidget::updateStatus()
{
  VersionData version;
  ProcessManager manager(0);
  if ( !manager.start() ) _status->setText(i18n("Could not start \"gpsim\""));
  else if ( !manager.getVersion(version) || !version.isValid() ) _status->setText(i18n("Could not detect \"gpsim\" version"));
  else _status->setText(i18n("Found version \"%1\"").arg(version.pretty()));
}

//----------------------------------------------------------------------------
::Programmer::ConfigWidget *GPSim::GroupUI::createConfigWidget(QWidget *parent) const
{
  return new ConfigWidget(static_cast<const ::Programmer::Group &>(group()), parent);
}
