#!/usr/local/bin/perl -- # -*- perl -*-
eval 'exec /usr/local/bin/perl -S $0 "$*"'
    if undef;
#
# DESCRIPTION
#
#     The postupdate perl script is intended for use with
#     PilotManager.  It will take all your memos in a certain category
#     and send them as email using sendmail.
#
#     Send comments and bug reports to:
#        Martin von Weissenberg, mvw@hut.fi
#
#
# INSTALLATION AND USAGE
#
#     Make sure this file is executable ("chmod 755 postupdate").
#     Edit the following variables to suit your needs.  Note that I
#     like to have my outgoing mail text wrapped, thus messages are
#     piped through fold.  A similar function could have been
#     implemented in Perl, but why reinvent the wheel?
#     Make sure $outboxdir is set to the correct location of your SyncMemo
#     files.
#
#     Useful sendmail options are:
#        -F fullname
#        

$sendmail = "/usr/bin/fold -s -w 72 | /usr/lib/sendmail -t";
$outboxdir = $ENV{HOME} . "/.pilotmgr/SyncMemo/Outbox";
$signature = $ENV{HOME} . "/.signature";
$logfile = $ENV{HOME} . "/.pilotmgr/maillog";

#     Now open PilotManager and configure SyncMemo.  The Post-Update
#     field should contain the full path name of this file.  If you
#     want to execute additional scripts you must make a wrapper
#     script.  Make sure the "Run post-update script after sync" and
#     "Do Pilot->File Transfers" buttons are checked.
#
#     Create a new category named "Outbox" on your Pilot.  Now, upon
#     sync, all memos in that category will be copied to the
#     workstation, sent as email and finally deleted.  The next time
#     you sync, the memo will be deleted on the Pilot too, unless you
#     have made changes to it, in which case it'll be handled as a new
#     mail waiting to be sent.  This may or may not be what you want.
#     I recommend storing unfinished mail in the Unfiled category;
#     move them to the Outbox when ready to send.
#
#     The first line of each memo must contain the recipient address.
#     If the address is not a valid email address the message will be
#     sent and deleted but will probably bounce.  The second line must
#     contain the subject.  The "To:" and "Subject:" prefixes are
#     optional.  Additional headers can be added starting from line 3
#     and will be sent verbatim.
#

# Start by getting all file names in the outbox directory; only text
# files as written by SyncMemo and no subdirectories.
opendir(dirl, $outboxdir);
@files = grep {-T "$outboxdir/$_"} readdir(dirl);
closedir(dirl);

# Iterate through the files
foreach $fn (@files) {
    $filename = $outboxdir."/".$fn;

    print(STDERR "Sending \"".$fn."\" ");

    open (MEMO, $filename);

# The first line must contain a recipient or we will skip the file
    $recipient = <MEMO>;
    $recipient =~ s/^to: //io;
    $recipient =~ s/^[ \t\n\l\r]*//o;
    $recipient =~ s/[ \t\n\l\r]*$//o;

    print (STDERR "to ".$recipient."... ");

# The following lines could probably clean up the address a little, if
# needed.  For now, trust the user to write correct email addresses.
# If not, the email will bounce...
#    $recipient =~ s/.*([A-Za-z0-9_]*@[A-Za-z0-9_]*).*/($1)/;

# Open a sendmail pipe for writing, note that $recipient is given as
# an argument to sendmail
    open (SM, join(" ", "|", $sendmail, "\"".$recipient."\"" ));
    print (SM "To: " . $recipient ."\n");
    
# The second line contains the subject
    $subject = <MEMO>;
    $subject =~ s/^subject: //io;
    $subject =~ s/^[ \t\n\l\r]*//o;
    $subject =~ s/[ \t\n\l\r]*$//o;

    print (SM "Subject: " . $subject . "\n");
    
# Copy the rest verbatim to sendmail.  Avoid lines containing one dot
# only, since sendmail interpretes a single dot on a line for itself
# as EOF.
    while ($line = <MEMO>) { print (SM $line); }
    print (SM "\n");		# empty line
    close (MEMO);
    
# Do we have a signature?
    if ( -r $signature ) {
	open (SIG, $signature);
	while (<SIG>) { print (SM $_ ); }	# copy the sig
	close (SIG);
    }
# Close and send.  Clean up the file.
    close (SM);
    system("rm -f \"$filename\"");
    print(STDERR "sent\n");
    open (LOG, ">>" . $maillog);
    print (LOG join(" ", "To", $recipient, "with subject",
		    "\"".subject."\"", "at", localtime()));
    close (LOG);

}

