/***************************************************************************
 *            qof-datebook.h
 *
 *  Thu Oct 21 15:38:58 2004
 *  Copyright  2004-2007  Neil Williams
 *  linux@codehelp.co.uk
 ****************************************************************************/
/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/** @addtogroup QOF
	@{ */
/** @addtogroup DB Datebooks and Appointments

A note on TIME:
	- QOF uses UTC time throughout
	- QSF uses UTC time in the XML, using the Z timezone-neutral designation.
	- pilot-link and the Palm use localtime.

The pilot-link QOF objects therefore expect UTC time from QOF and pass
\b localtime to the pilot-link code.

	@{ */
/** @file  qof-datebook.h
	@brief QOF datebook definitions for pilot-link
	@author Copyright (c) 2004-2007 Neil Williams <linux@codehelp.co.uk>
*/

#ifndef _QOF_DATEBOOK_H
#define _QOF_DATEBOOK_H

#include "pi-datebook.h"

/** \name QOF object declaration
@{
*/
#define DATEBOOK_VERSION datebook_v1
#define PILOT_LINK_QOF_DATEBOOK "pilot_datebook"
#define QOF_DATEBOOK_DESC       "Pilot-link QOF datebook"
#define DATEBOOK_DESCRIPTION    "description"
#define DATEBOOK_DURATION       "duration_hours"

/** @} */

/** \brief Is this a transient repeat object?

To make it easier to query repeat appointments, transient
events are created for each incidence of a repeat. This
parameter allows such transient events to be ignored in
certain queries. */
#define DATEBOOK_REPEATER          "transient_repeat"

#define DATEBOOK_KVP_PATH          "datebook/exceptions"
#define DATEBOOK_EVENT        "untimed_event"
#define DATEBOOK_BEGIN        "start_time"
#define DATEBOOK_END          "end_time"
#define DATEBOOK_ALARM        "use_alarm"
#define DATEBOOK_ADVANCE      "alarm_advance"
#define DATEBOOK_ADV_UNIT     "advance_unit"
#define DATEBOOK_REPEAT_TYPE  "repeat_type"
/** \brief Does the repeat have an end?

If set, any value in repeat-end is ignored.
*/
#define DATEBOOK_REPEAT_FOREVER    "repeat_forever"
#define DATEBOOK_REPEAT_END        "repeat_end"
#define DATEBOOK_REPEAT_FREQUENCY  "repeat_frequency"
#define DATEBOOK_REPEAT_DAY        "repeat_day"
#define DATEBOOK_REPEAT_WEEK_START "repeat_week_start"
#define DATEBOOK_EXCEPTIONS        "exception_count"
#define DATEBOOK_EXCEPTION         "exception_list"
#define DATEBOOK_NOTE              "note"
#define DATEBOOK_CATEGORY          "category"

/** Register the datebook with QOF */
gboolean DateBookRegister (void);

Appointment_t * datebook_get_pilot (QofInstance * inst);

void
datebook_repeater_clone (QofEntity * obj, QofTime * qt_end, QofTime * qt_increment);

#endif /* _QOF_DATEBOOK_H */
/** @} */
/** @} */
