<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:qof-qsf="http://qof.sourceforge.net/" xmlns:dt="http://xsltsl.org/date-time" xmlns:date="http://exslt.org/dates-and-times" xmlns:str="http://xsltsl.org/string" version="1.0">
  <xsl:import href="date-time.xsl"/>
  <xsl:import href="string.xsl"/>
  <xsl:import href="date.difference.xsl"/>
<!-- our own pilot-qof standard routines -->
  <xsl:import href="pilot-qof-std.xsl"/>
  <xsl:output method="text"/>
<!-- Representing QSF XML todo data in a vToDo format

  This stylesheet converts the output from pilot-qof -d pilot_todo
  into an vtodo file.

  See the Pilot-QOF Extensions Manual for more information.
-->
<!-- Licence

  This file is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
-->
  <xsl:template match="/">
    <xsl:message>.</xsl:message>
    <xsl:message>This stylesheet is part of pilot-qof.</xsl:message>
    <xsl:message>pilot-qof is free software (GPL) and comes with NO WARRANTY.</xsl:message>
    <xsl:message>See 'COPYING' in the pilot-qof source for more information.</xsl:message>
    <xsl:message>Writing pilot-qof data to vtodo.</xsl:message>
    <xsl:apply-templates select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_todo']"/>
  </xsl:template>

  <xsl:template match="/*/qof-qsf:book/qof-qsf:object[@type='pilot_todo']">
    <xsl:variable name="todo_date">
      <xsl:call-template name="dt:format-date-time">
        <xsl:with-param name="xsd-date-time" select="qof-qsf:time[@type='date_due']"/>
        <xsl:with-param name="format" select="'%Y%m%dT%H%MZ'"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:text>BEGIN:VTODO&#10;</xsl:text>
    <xsl:text>UID:</xsl:text>
    <xsl:value-of select="qof-qsf:guid[@type='guid']"/>
    <xsl:text>&#10;DTSTAMP:</xsl:text>
    <xsl:value-of select="$todo_date"/>
    <xsl:text>&#10;DTSTART:</xsl:text>
    <xsl:value-of select="$todo_date"/>
	<xsl:text>&#10;DUE:</xsl:text>
    <xsl:value-of select="$todo_date"/>
    <xsl:text>&#10;SUMMARY:</xsl:text>
    <xsl:value-of select="qof-qsf:string[@type='description']"/>
    <xsl:text>&#10;DESCRIPTION:</xsl:text>
    <xsl:value-of select="qof-qsf:string[@type='note']"/>
    <xsl:text>&#10;CLASS:PUBLIC</xsl:text>
	<xsl:text>&#10;PRIORITY:</xsl:text>
	<!-- 10 - @type='priority' -->
	<xsl:text>&#10;STATUS:</xsl:text>
	<xsl:value-of select="qof-qsf:string[@type='complete']"/>
    <xsl:text>&#10;END:VTODO&#10;&#10;</xsl:text>
  </xsl:template>
</xsl:stylesheet>
