<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:qof-qsf="http://qof.sourceforge.net/" xmlns:str="http://xsltsl.org/string" version="1.1">
  <xsl:import href="string.xsl"/>
  <!-- our own pilot-qof standard routines -->
  <xsl:import href="pilot-qof-std.xsl"/>
  <xsl:output method="text"/>
<!-- Representing QSF XML address data in a 2.1 extended VCard 

  This stylesheet converts the output from pilot-qof -d pilot_address
  into a verbose Vcard, suitable for import into KAdddressbook. For more limited 
  VCard support (e.g. for mobile phones), see other vcard XSL stylesheets in the 
  pilot-qof collection.

  Each VCard is written into a separate .vcf file, named after the 
  contact described in the pilot_address records. Spaces are replaced with
  underscores. Specify the '-o dir/' option to xsltproc to output all vcards
  into a directory.

  This stylesheet does not currently identify which phone number is work and
  which is home etc. - it simply assumes that Phone1 is work, Phone2 is home,
  Phone3 is mobile, Phone4 is fax and Phone5 is email.
  Patches welcome!  :-)

-->
<!-- Licence

  This file is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
-->

  <xsl:template match="/">
    <xsl:for-each select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_address']">
      <xsl:variable name="contactName">
        <xsl:value-of select="qof-qsf:string[@type='entryFirstname']"/>
        <xsl:value-of select="qof-qsf:string[@type='entryLastname']"/>
      </xsl:variable>
      <xsl:variable name="card_title">
      <xsl:call-template name="get_chunk_name">
        <xsl:with-param name="entryCompany" select="qof-qsf:string[@type='entryCompany']"/>
        <xsl:with-param name="entryName" select="$contactName" />
      </xsl:call-template>
      </xsl:variable>
      <!-- chunking support -->
      <xsl:document href="{$card_title}.vcf" method="text">

        <xsl:text>BEGIN:VCARD&#10;VERSION:2.1&#10;N:</xsl:text>
        <xsl:value-of select="$card_title"/>
        <xsl:text>&#10;TEL;TYPE=WORK:</xsl:text>
        <xsl:value-of select="qof-qsf:string[@type='entryPhone1']"/>
        <xsl:text>&#10;TEL;TYPE=HOME:</xsl:text>
        <xsl:value-of select="qof-qsf:string[@type='entryPhone2']"/>
        <xsl:text>&#10;TEL;TYPE=CELL:</xsl:text>
        <xsl:value-of select="qof-qsf:string[@type='entryPhone3']"/>
        <xsl:text>&#10;TEL;TYPE=FAX:</xsl:text>
        <xsl:value-of select="qof-qsf:string[@type='entryPhone4']"/>
        <xsl:text>&#10;EMAIL:</xsl:text>
        <xsl:value-of select="qof-qsf:string[@type='entryPhone5']"/>
        <xsl:text>&#10;TITLE:</xsl:text>
        <xsl:value-of select="qof-qsf:string[@type='entryTitle']"/>
        <xsl:text>&#10;ORG:</xsl:text>
        <xsl:value-of select="qof-qsf:string[@type='entryCompany']"/>

        <xsl:text>&#10;END:VCARD&#10;</xsl:text>
      </xsl:document>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
