/*
   SPDX-FileCopyrightText: 2020 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: GPL-2.0-or-later
*/

#ifndef IMPORTCALENDARJOBINTERFACETESTIMPL_H
#define IMPORTCALENDARJOBINTERFACETESTIMPL_H

#include "exportimportutil.h"

#include "calendar/importcalendarjobinterface.h"

class ImportCalendarJobInterfaceTestImpl : public ImportCalendarJobInterface, public ExportImportUtil
{
    Q_OBJECT
public:
    explicit ImportCalendarJobInterfaceTestImpl(QObject *parent, Utils::StoredTypes typeSelected, ArchiveStorage *archiveStorage, int numberOfStep);
    ~ImportCalendarJobInterfaceTestImpl();

    void setExistingPathConfig(const QString &path);
protected:
    Q_REQUIRED_RESULT Akonadi::Collection::Id convertFolderPathToCollectionId(const QString &path) override;
    Q_REQUIRED_RESULT QString createResource(const QString &resources, const QString &name, const QMap<QString, QVariant> &settings, bool synchronizeTree = false) override;
    void synchronizeResource(const QStringList &lst) override;
    Q_REQUIRED_RESULT QString adaptResourcePath(const KSharedConfigPtr &resourceConfig, const QString &storedData) override;
    Q_REQUIRED_RESULT QString adaptNewResourceUrl(bool overwriteResources, const KSharedConfig::Ptr &resourceConfig, const QString &storePath) override;
    Q_REQUIRED_RESULT QString configLocation() const override;
private:
    QString mExistingPathConfig;
};

#endif // IMPORTCALENDARJOBINTERFACETESTIMPL_H
