/*********************************************************************
 *                
 * Copyright (C) 2002, 2003,  Karlsruhe University
 *                
 * File path:     x86-syscalls.c
 * Description:   syscall gate relocation
 *                
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *                
 * $Id: x86-syscalls.c,v 1.2.4.1 2003/09/24 19:13:54 skoglund Exp $
 *                
 ********************************************************************/
#include <l4/types.h>
#include <l4/kip.h>

#define DEFINE_SYSCALL(syscall)				\
void (*__L4_##syscall)(void);				\
void __LibL4_Init_##syscall(void);			\
asm ("__LibL4_Init_"#syscall":\n"			\
     "pusha\n"						\
     "call __LibL4_Init\n"				\
     "popa\n"						\
     "jmp *__L4_"#syscall);				\
void (*__L4_##syscall)(void) = __LibL4_Init_##syscall;


DEFINE_SYSCALL(Ipc)
DEFINE_SYSCALL(Lipc)
DEFINE_SYSCALL(ExchangeRegisters)
DEFINE_SYSCALL(ThreadControl)
DEFINE_SYSCALL(SystemClock)
DEFINE_SYSCALL(ThreadSwitch)
DEFINE_SYSCALL(Schedule)
DEFINE_SYSCALL(Unmap)
DEFINE_SYSCALL(SpaceControl)
DEFINE_SYSCALL(ProcessorControl)
DEFINE_SYSCALL(MemoryControl)

#define SET_SYSCALL(syscall) __L4_##syscall = (void(*)(void))((L4_Word_t)kip + kip->syscall)

void __LibL4_Init(void)
{
    L4_Word_t dummy;
    L4_KernelInterfacePage_t * kip = (L4_KernelInterfacePage_t*)
	L4_KernelInterface(&dummy, &dummy, &dummy);

    SET_SYSCALL(SpaceControl);
    SET_SYSCALL(ThreadControl);
    SET_SYSCALL(ProcessorControl);
    SET_SYSCALL(MemoryControl);

    SET_SYSCALL(Ipc);
    SET_SYSCALL(Lipc);
    SET_SYSCALL(Unmap);
    SET_SYSCALL(ExchangeRegisters);

    SET_SYSCALL(SystemClock);
    SET_SYSCALL(ThreadSwitch);
    SET_SYSCALL(Schedule);
}


