# 0.91 Release “Charming Defects”

This is the first alpha release for the new version of Pitivi based on
[GES](GES.md), the GStreamer Editing Services library.

It is a major rework of the entire Pitivi
[architecture](Architecture.md. It includes:

-   Replacing the core of Pitivi by GES; 20 thousand lines of code
    removed
-   Porting to GStreamer 1.x
-   Porting to GTK+ 3.x
-   Replacing GooCanvas by Clutter for the timeline
-   An automated UI test suite, with many checks for mission-critical
    parts
-   Fixing hundreds of bugs and implementing many new features
-   UI polish all over the place
-   Refactoring pretty much the entire codebase

To give you a visual idea of what this meant:
<http://jeff.ecchi.ca/blog/wp-content/uploads/2012-02-28-12.42.44-levelled.jpg>

<span style="background:#FF0000">**WARNING**</span>: Please keep in mind
that this is an *alpha* release, so there may be some bugs we haven't
found yet. We appreciate your feedback, so try it out, let us know how
well it works for you and report detailed bugs for issues you may
encounter. Again, this is <span style="color:#FF0000">not yet considered
production-ready software</span>. We can't be sure until we test and
iron out the bugs! With your help, we will follow up with a beta release
and eventually a [1.0](releases/1.0.md) release.

## Top features of this release

These features have been documented throughout many blog posts from
January 2012 to September 2013. Take a look at the [“Pitivi” category of
Jeff's blog](http://jeff.ecchi.ca/blog/category/pitivi) for additional
details and historical context.

### Media Library

-   The redesigned clip previewing feature gives you more space to view
    a video from the media library, yet stays out of your way. It now
    opens a separate window that tries to show the clip at 1:1 size
    whenever possible. This window can be dismissed by clicking the
    close button or clicking anywhere outside the window, so there is no
    reduction of efficiency compared to the old approach.
-   Use Nautilus/Totem’s thumbnails and conform to the new version of
    the Freedesktop specification for thumbnail directories. The result
    is prettier and we don’t have to do processing in most cases, which
    means even faster import/loading times.
-   Asynchroneous (non-blocking) and much faster clip importing
-   The media library keeps itself sorted alphabetically as you import
    files, without any additional performance hit.
-   Prevent playing back clip previews in double (that was a subtle one,
    as windows were exactly on top of each other)
-   Make special characters show up correctly in the media library’s
    iconview mode, remove the ancient filename shortening code and rely
    on Pango instead.
-   Avoid excessive work when searching clips in the media library,
    improving performance
-   Handle special characters in the media library’s search entry
-   Use the system’s default image viewer to preview images

### Timeline and Playback

![](images/Complex_layers_whiteboard_mockup_from_desktop_summit_2011.png "Complex_layers_whiteboard_mockup_from_desktop_summit_2011.png"){width="700"}

-   Smooth, modern Clutter-based timeline with animations to enhance
    usability
-   Smooth autoscrolling while playing
-   [Live preview of what you are
    trimming](http://jeff.ecchi.ca/blog/2012/03/07/trim-like-a-professional-hair-stylist/).
    No more trial and error, no more fuzzying around and moving the
    playhead all the time to figure out if you cut your scene right.
-   Playback performance back to the 0.13.1 levels (or possibly better).
    Want to play a 1080p clip? A 2K clip? Not a problem anymore (unless
    you're still running on a 286 or something).
-   Much faster and prettier video thumbnails on the timeline, with
    two-stage caching and adaptive CPU usage throttling
-   Much faster and more accurate audio waveforms, with on-disk caching
-   Manual layers management interface, layer reordering
-   The timeline toolbar is now vertical and sports improved “Split”,
    “Group” and “Ungroup” icons. It also does away with obsolete
    buttons.
-   Automatic rippling (a.k.a. “magnetic”, elastic, fantastic) timeline
    mode: this makes your clips behave like magnets and prevents needing
    to re-arrange them manually all the time.
-   Automatically adjust the zoom when inserting to the end of the
    timeline
-   New icons for split, group/ungroup and align
-   Clip snapping indicator

### For contributors and distributors

-   Infinitely cleaner and easier to navigate codebase. See [this blog
    post](http://jeff.ecchi.ca/blog/2012/01/12/spring-clean-up-in-january/)
    and [this blog
    post](http://jeff.ecchi.ca/blog/2012/02/02/aventuras-en-malaga-y-ronda/)
    for an explanation and some numbers, or just look at [this
    screenshot](http://jeff.ecchi.ca/blog/wp-content/uploads/pitivi-tree-cleanup.png)
    comparing the old and new amount of source files.
-   An awesome [test suite](Testing.md)
-   A revised and simplified API has been implemented in GES and
    integrated in Pitivi.
-   A small [brand
    adjustment](https://git.gnome.org/browse/pitivi/commit/?id=549e1e3b).
    From now on, PiTiVi should simply be called “Pitivi”.
-   Dependencies are defined and checked in only one, centralized place:
    check.py
-   We now use yelp-tools instead of gnome-doc-utils
-   New format for which a mimetype needs to be registered: xges
-   Commandline rendering, scripting and batch processing is now GES'
    job
-   New high-resolution logo icon
-   Various pieces of documentation (README, HACKING, AUTHORS, etc.)
    were updated
-   We ship an AppData file in order to show up with the correct
    description in GNOME Software
-   We dropped the ChangeLog file, it weighs a ton and we have this
    thing called version control systems now.

### General

-   In addition to the good old “crossfade”, you can now choose from 70
    industry-standard
    ([SMPTE](https://en.wikipedia.org/wiki/Society_of_Motion_Picture_and_Television_Engineers))
    transitions. This number doubles to 140 if you consider that each
    transition can also be reversed.
-   Pitivi now inhibits the screensaver when playing and inhibits
    suspend when rendering.
-   The automated backup feature now works. See [this blog
    post](http://jeff.ecchi.ca/blog/2012/01/25/restoring-from-backups/)
    and [its
    sequel](http://jeff.ecchi.ca/blog/2013/09/04/fix-it-thrice/)
-   Simplified menus
-   Fix many, many, many problems with the Media Library, project
    management, keyboard shortcuts, etc.
-   Ability to save/export the current frame as an image file
-   Much faster application startup
-   Auto-hiding toolbar in fullscreen mode
-   Improved error dialogs
-   Automatically saving and restoring the state of our dynamic
    detachable tabs/components.
-   Redesigned rendering progress dialog and post-render user
    experience. See
    [this](http://jeff.ecchi.ca/blog/2012/11/15/persistent-tab-states-render-ux-polish-and-other-things/),
    [this](http://jeff.ecchi.ca/blog/2013/04/28/no-more-stuck-render-dialogs/)
    and [this](http://jeff.ecchi.ca/blog/2013/09/04/fix-it-thrice/).
-   Enforce unicode in preset names, preventing a bug with non-ASCII
    chars are used in the name of a preset
-   Allow presets with “/” in their name
-   Fix a race between clicks on the preview widget’s slider and
    position updates. When using it in the media library/file chooser,
    the slider would often “jump” back to its previous position instead
    of seeking. The new behavior is now smooth and reliable.
-   When the viewer is undocked, provide a button to toggle fullscreen
    mode
-   Specify the duration of missing/moved files when prompting the user
    about their new location
-   Update effect categories, merge “Noise” and “Blur”, add a
    “Compositing” category, categorize new effects
-   Automatically save the last used render directory
-   Stop rendering when the user presses Escape
-   Use symbolic icons everywhere where it makes sense (in the media
    library toolbar, property reset buttons, lists, etc.)
-   Update the preview widget slider on a more frequent basis, giving it
    a snappier feeling
-   Automatically save and restore the main window’s position. This is
    especially useful when using detached utility windows.
-   Hide the effects toolbar when nothing is selected
-   Add a contextual help button in the render dialog to explain
    container formats
-   Allow entering a frame number into the time widget
-   Keyframable (animatable) properties for all effects
-   Scale down effects thumbnails to fit better in the new listview
    arrangement
-   Various improvements to the robustness of the import dialog's video
    previewer
-   Ability to pause and resume rendering
-   A basic title editor
-   Filter the project loading or media file importing dialogs to only
    show relevant/supported files by default
-   Only show codecs and containers with a high-enough GStreamer “rank”
    to reduce the possibility of rendering problems

This is just the beginning, of course. See the “Bugs fixed (and even
more features)” section further below if you're hungry for more.

## Requirements

Dependencies/requirements have changed significantly since the 0.15
series.

Generally speaking, you can refer to Pitivi's check.py for the
dependencies' versions specific to a given release. For 0.91, those are:

Hard requirements:

-   cairo &gt;= 1.10.0
-   clutter &gt;= 1.12.0
-   gnonlin &gt;= 1.1.90
-   gobject-introspection &gt;= 1.34.0
-   gst-python &gt;= 1.1.90
-   gstreamer &gt;= 1.2.0
-   gstreamer-editing-services &gt;= 1.1.90
-   gtk &gt;= 3.8.0
-   numpy (static bindings)
-   pygobject &gt;= 3.4.0
-   pyxdg (static bindings)

Soft requirements:

-   gstreamer-libav
-   libnotify
-   pycanberra (static bindings)
-   frei0r

See also [dependencies](attic/Dependencies.md) for additional tips.

## Known issues

-   Layer management interface is missing features.
-   The title editor UI is very primitive and probably buggy. Please
    join us to make it work up to your expectations! See the existing
    [title editor
    bugs](https://bugzilla.gnome.org/buglist.cgi?product=pitivi&bug_status=UNCONFIRMED&bug_status=NEW&bug_status=ASSIGNED&bug_status=REOPENED&component=Title%20editor).
-   The transformation box has been disabled (we need someone to [fix
    it](https://bugzilla.gnome.org/show_bug.cgi?id=708495)).
-   The user manual is completely outdated (it references the
    [0.15](releases/0.15.md) series). We are looking for someone to take
    on the role of writing the Pitivi user guide. Please get in touch if
    you love writing and are interested in helping out.
-   Translations are not all fully up to date.
-   The Media Library does not generate missing thumbnails. See
    [GStreamer bug
    667203](https://bugzilla.gnome.org/show_bug.cgi?id=667203) for
    details.
-   The [ruler has not been ported to
    Clutter](https://bugzilla.gnome.org/show_bug.cgi?id=708491), so it
    will not be in sync with the rest of the timeline while
    autoscrolling.
-   The automated codecs installer is (still) broken. See [bug
    686182](https://bugzilla.gnome.org/show_bug.cgi?id=686182) and [GES
    bug 686181](https://bugzilla.gnome.org/show_bug.cgi?id=686181).
-   The automatic clip aligner feature does not work. We need someone to
    [port it to use our new audio waveforms processing
    module](https://bugzilla.gnome.org/show_bug.cgi?id=708401).
-   If xptv file support is important to you, we urgently need someone
    to get involved in fixing/refactoring the xptv formatter module in
    GES. If no interest is shown after a few releases, support for this
    legacy file format may be dropped.
-   [No dialog to install missing codecs after discovering
    clips](https://bugzilla.gnome.org/show_bug.cgi?id=686182), and no
    error gets raised in that case. This means that the clip will
    “appear” to have imported correctly, but if you try inserting it
    into the timeline you may get errors in the background or Pitivi's
    UI may hang.

See the list of [currently known
issues](https://bugzilla.gnome.org/buglist.cgi?query_format=advanced;bug_severity=blocker;bug_severity=critical;bug_severity=major;bug_severity=normal;bug_severity=minor;bug_severity=trivial;bug_status=NEW;bug_status=ASSIGNED;bug_status=REOPENED;product=pitivi),
the [0.91-specific
issues](https://bugzilla.gnome.org/buglist.cgi?query_format=advanced&version=0.91&resolution=---&product=pitivi)
and the list of [bugs that need re-testing with
0.91](https://bugzilla.gnome.org/buglist.cgi?query_format=advanced;bug_status=NEEDINFO;target_milestone=0.91;product=pitivi)
(you can help!)

## Bugs fixed (and even more features)

It is difficult to evaluate the amount of commits directly related to
Pitivi in GStreamer. However:

-   At least 50 bugs in GStreamer have been fixed by Mathieu Duponchelle
    between January and September 2013:
-   At least [96
    bugs](https://bugzilla.gnome.org/buglist.cgi?chfieldto=2013-09-30;query_format=advanced;chfieldfrom=2011-08-01;longdesc=pitivi;longdesc_type=allwordssubstr;product=GStreamer)
    in GStreamer since [0.15](releases/0.15.md) mention Pitivi

In GStreamer Editing Services, the Pitivi team has made 975 commits in
preparation for this release.

In Pitivi:

-   [Hundreds of bug
    reports](https://bugzilla.gnome.org/buglist.cgi?query_format=advanced&target_milestone=0.91&product=pitivi)
    were resolved
-   There were 1348 commits between 0.15.2 and 0.91.

Since you're reading the release notes of an an alpha release, we
suspect you might be pretty geeky, so here are roughly 150 (of the 1300+
commits) that are “interesting” but were not necessarily big enough to
be mentioned in the “top features” above.

`   0d21848 Kill ChangeLog with fire`\
`   c07dc1b mediafilespreviewer: Remove sync-message handler and add proper xid handling`\
`   a0a21e6 viewer: Use the `“`realize`”` GTK callback to asynchronously obtain window handle`\
`   6f4c58f viewer: Disable GTK double buffering to prevent flickering and black images`\
`   351a833 project, timeline: Set restriction caps on tracks.`\
`   e2c59ca timeline: Reimplement the seeking and framestepping keyboard shortcuts`\
`   1362142 pitivi: Rely on timeline widgets' focus to set actions/shortcuts sensitivity`\
`   81cd77c check: Drop the GooCanvas dependency`\
`   e956801 Redesign the rendering progress dialog`\
`   a568665 render: Provide an estimation of the output file size`\
`   6b2e69b mainwindow: Make context tabs (2nd child of the 2nd hpane) not resize themselves`\
`   d276be2 pitivi: Implement the notion of `“`read-only`”` projects`\
`   0008538 project: Refactor and fix saveProject`\
`   054489a Conform to the AppData spec so we show up properly in the GNOME Software Center`\
`   88ebb08 Fix .desktop file categories so that Pitivi will show up in GNOME Software`\
`   b61048d mediafilespreviewer: Always use the same videosink`\
`   54dc09f pipeline: when not in RENDER, the pipeline can and must recover`\
`   75b96b2 Use yelp-tools instead of gnome-doc-utils`\
`   24189e4 Properly parent the `“`Render`”` and `“`Project`` ``Settings`”` dialogs`\
`   a9900d7 medialibrary: Support the new `“`large`”` (256 pixels) thumbnails`\
`   127e6e6 medialibrary: Handle multiple sizes for fallback icons when there are no thumbs`\
`   e360b2a mediafilespreviewer: Fix the icon shown when previewing audio files`\
`   1d1e1ed Make the import filechooser dialog modal so that it works in fullscreen`\
`   6599953 timeline/elements: Improve the appearance and visibility of the keyframe curves`\
`   d9f5364 utils/widgets: Fill sliders with color to indicate the default values`\
`   3d02054 check: Make numpy a hard dependency as we now need it for core audio waveforms`\
`   43255f6 previewers: Delay initial thumbnail & waveform processing to when the UI is idle`\
`   b04c221 Regulate the frequency at which thumbnails get created.`\
`   50546b0 previewers: add saving and loading for the waveforms.`\
`   caccf69 This commit adds a waveform audio previewer.`\
`   7154b06 pitivi: Port to the new commit based API in GES`\
`   ddcee62 previewers: Periodically save clip thumbnails`\
`   e492dde previewers: Avoid blocking the UI when generating clip thumbnails`\
`   4a01a2e mainwindow: Ensure `“`Clip`` ``properties`”` is the focused context tab on startup`\
`   e70b055 render:  Show rendering errors in a dialog`\
`   62157c7 Do not set titles on modal message dialogs, they are redundant with the contents`\
`   71a9d45 Define some more harmonized default colors for timeline elements/clips`\
`   aa64ac9 Save resources by only drawing the visible thumbs`\
`   4a0cb3c Improve clip thumbnailing performance when scrolling/zooming the timeline`\
`   f47b1f9 Various performance improvements to the timeline clip thumbnailer`\
`   ff50eb2 Register mimetypes for the new xges project format`\
`   c86d33f New X-Large (256x256) logo icon`\
`   e643fb5 Add a button to toggle a `“`gapless`”` (auto-ripple) timeline mode`\
`   d5bd8dc clipproperties: Prevent drag and drop `“`ghosts`”` from the effects library`\
`   cbd8910 Add a contextual help button in the render dialog to explain container formats`\
`   931a445 clipproperties: Use a symbolic icon for the `“`Remove`` ``effect`”` inline tool button`\
`   c31a230 Automatically save and restore the main window's position`\
`   f2389ad Use symbolic icons for the `“`Reset`` ``to`` ``default`` ``value`”` dynamic widget buttons`\
`   b3be493 mediafilespreviewer: Update the preview widget slider on a more frequent basis`\
`   1fcbbe6 Use the system's default image viewer to preview images from the media library`\
`   76573e8 Fix a race between clicks on the preview widget's slider and position updates`\
`   f67b9ea Use symbolic icons everywhere in the Media Library toolbar`\
`   1a51f04 render: Stop rendering when the user presses Escape`\
`   4b4e969 render: Properly save the render directory`\
`   2f2c92a effects: Scale down thumbnails to fit better in the new listview arrangement`\
`   3ef1f81 utils/ui: Properly ignore subtitles, including the new DiscovererSubtitleInfo`\
`   4c10b27 medialibrary: Force quoting URIs right before computing the thumbnail hash`\
`   89dc28e utils/misc: Use Gst.filename_to_uri instead of manually encoding URIs`\
`   42587d3 medialibrary: Remove the ancient filename shortening code, rely on Pango instead`\
`   b2309e9 medialibrary: Make special characters show up correctly in iconview mode`\
`   1f766ab medialibrary: Rework the way we sort files in the view`\
`   6b5b009 medialibrary: Respect the fdo spec to find thumbnails`\
`   1301dab Specify the dependencies version requirements in only one place (check.py)`\
`   248e0a2 Refactor check.py for faster, better (simpler), stronger dependency checking`\
`   3ab1026 Remove the pitivi.spec file`\
`   d52614c Remove the ABOUT-NLS file, it's completely useless`\
`   2b5ef0c Update AUTHORS to match the About dialog`\
`   3361da9 New icons for split, group/ungroup and align`\
`   b0a36cd viewer: When undocked, show a button to toggle fullscreen mode`\
`   9d50648 mainwindow: Make the medialibrary previewer work even in fullscreen mode`\
`   c9493f9 medialibrary: Do not emit `“`play`”` twice when double-clicking a clip`\
`   d9f3034 preset: Allow presets with slash chars in the name`\
`   bcf90cf Notify and play a sound when rendering is complete`\
`   b0617ea tabsmanager: Restore the state of undocked utility windows on startup`\
`   a4c3674 tabsmanager: Save/restore settings from detached tabs`\
`   5c063a6 Refine the `“`Split`”` icon to be pixel-perfect and closer to a symbolic style`\
`   4f417ef medialibrary: Use MIME types instead of extensions for filtering the filechooser`\
`   6bc2427 Make the code compliant with PEP8 1.3`\
`   0fb0c0e Set widget names for AT-SPI/accessibility`\
`   6d9a4d0 Remove the code to hide/show toolbars`\
`   e63d158 Hide the menubar in fullscreen mode`\
`   3ee3ea5 Auto-hide and show the main toolbar in fullscreen mode`\
`   ca61a6d timeline: Add missing labels to (un)group and align`\
`   f7a10b1 timeline: Remove `“`Keyframe`”` from the toolbar, but keep the keyboard shortcut`\
`   4b4291a mainwindow: Make the timeline toolbar vertical`\
`   6e70641 Make the filename entry in render dialog activate the Render action`\
`   1c1807a mainwindow: Filter for the file's extension when prompting for missing files`\
`   4568997 medialibrary: Only show known file formats by default in the filechooser`\
`   254f50c mainwindow: Fix the filechooser filter for opening project files`\
`   b295b6a render: Properly parent the advanced codec settings dialogs`\
`   55ba545 mediafilespreviewer: Add support for the `“`copyright`”` tag`\
`   454e65b Move the media and effect library toolbars to the top for consistency`\
`   e0a04cd transitions: Use a symbolic icon and placeholder text for search`\
`   67aba11 effects: Use an inline toolbar for searching and categories`\
`   4240ea5 medialibrary: Use GtkBuilder for infobars`\
`   70f2ba9 Implement a Media Library toolbar and kill menu items`\
`   94d7d6b Document our keyboard shortcuts and allow contextual help`\
`   459532f Implement a title editor`\
`   c4cb00e medialibrary: Hide the infobar when sources start importing`\
`   857be52 Increase the amount of recent items in the welcome dialog to 10`\
`   d6006aa Implement the ability to go a frame forward or backwards`\
`   508dab0 When space is constrained, allow notebook tabs to scroll`\
`   16e2087 When not usable, hide widgets in clip properties and transitions`\
`   1b7cd97 Refactor clipproperties and fix the expansion behavior with GTK3`\
`   b59af58 Fixes traceback when user double-clicks on an empty row in the treeview`\
`   c469d35 Use symbolic toolbar icons in Project settings and Render dialog`\
`   11a4166 Use the GTK3 `“`inline`”` style for toolbars under presets listviews`\
`   3b63ba3 projectsettings UI: Force some fields to be numeric only`\
`   1d35ad3 Use the new GTK3 features for the About/credits dialog`\
`   8e90540 Set the `“`primary-toolbar`”` style on the main toolbar`\
`   1130ce7 Use a dark theme variant for GTK3`\
`   d996933 pitivi: Playbin2 is dead, use playbin`\
`   59b3956 Abort project loading when a clip does not have a replacement`\
`   edeb4e1 Effects: Merge icon and treeview into a single view`\
`   2c9e8f5 Make the about dialog's credits future-proof`\
`   9017fc6 Add tooltips to buttons at the bottom of the Preferences UI`\
`   d44d440 Implement UI testing with Dogtail`\
`   b5155c8 Prevent the timeline's Zoom Fit button from expanding`\
`   d205a51 Add a preference for the default duration of image clips in the timeline`\
`   493c226 Refactor GTK+ actions and keyboard shortcuts`\
`   194a714 timeline: Bind Ctrl+0 to the `“`Zoom`` ``fit`”` action`\
`   d8a09f9 mainwindow: Use standard shortcuts for Help and Fullscreen`\
`   995cedb medialibrary: Standardize playback in iconview and treeview`\
`   a63564e Create icons for transitions`\
`   c429604 Implement SMPTE video transitions`\
`   426257c Remove old mimetype icons`\
`   e04a3d2 Merge branch 'ges'`\
`   df36892 Show a better default progressbar text when starting rendering`\
`   dbc3a26 render: Set power management only when starting/resuming`\
`   6c70423 Allow pausing and resuming rendering`\
`   6886c57 timeline: When autoscrolling, jump to 1/6th of the width, not 1/2`\
`   f2ff6c3 timeline: Fix the horizontal scrollbar management for zooming`\
`   20ad0a2 Add a version checker`\
`   4c0abcb Show a vertical line to indicate clip snapping`\
`   608ab1a Port to the new GES timeline edition API`\
`   48b8d46 thumbnailer: Add on disk thumbnail caching`\
`   c012a2c Add the ability to render video only or audio only`\
`   f73e918 Add a `“`rule`` ``of`` ``thumb`` ``for`` ``long`` ``lines`”` to coding style conventions`\
`   2df0743 When run from git, don't show a stable version number in About`\
`   44787d9 Add version info to the About dialog`\
`   5b9f1e6 If available, show thumbnails for missing files to help the user`\
`   4ae8768 Cleanup the translatable strings in project settings`\
`   96c79e3 Set a better default height for the render dialog`\
`   98cd55e Allow copying a clip's properties to project settings`\
`   e8e7296 viewer: Preview the clips being trimmed`\
`   64fb372 Set the main official repository to be git.gnome.org/pitivi`\
`   e82764c Offer to to load the autosaved backup instead of the project file`\
`   4499155 Show the time for the unsaved changes confirmation dialog`\
`   d971cfc Allow saving a snapshot of the current frame as an image file`\
`   14ceaa0 medialibrary: Make discovery asynchroneous and show progress`

`   fdb9bd4 Disable timeline accels when focusing Media Library contents`\
`   6ff7983 Prevent Delete from being sensitive in Media Library and Effects`\
`   33ab288 Make the search bars use focus-in events to ensure you can't have sensitive actions that prevent them from working.`

`   431769b Kill the `“`Preview`”` menu and reorganize the `“`Timeline`”` menu`\
`   6a5e5df Selectively use the word `“`encoder`”` when talking about codecs`\
`   8759e58 pitivi/ui/encodingdialog.py: inhibit logging out, inhibit suspend/shutdown etc. when rendering`\
`   845d911 pitivi/ui/viewer.py: inhibit screensaver whilst previewing videos.`\
`   b7fcd7c Fix the resolution and framerate parsing in the Media Library`\
`   94bf5f2 ui: Get source thumbs from the Freedesktop thumbnail cache spec`\
`   23d08bb Ensure that previewed videos fit within a reasonable size`\
`   1ee2ada Put the Media Library previewer's playback controls at the top`\
`   39f271f Automatically set the size of the Media Library previewer`\
`   d95adeb Prevent the render dialog from having a blank output filename`

What, you want more?! Well, you can use this command in our code
repository:

`git log RELEASE-0_15_0..RELEASE-0_91_0`

# Contributors for this release

In Pitivi:

`  526  Jean-François Fortin Tam`\
`  266  Thibault Saunier`\
`  190  Mathieu Duponchelle`\
`   72  Paul Lange`\
`   37  Piotr Drąg`\
`   26  Alex Băluț`\
`   24  Daniel Mustieles`\
`   23  Matas Brazdeikis`\
`   18  Marek Černocký`\
`   17  Matej Urbančič`\
`   17  Nicolas Dufresne`\
`   14  Daniel Thul`\
`   12  René Stadler`\
`   10  Alexandru Băluț`\
`    8  Stephen Griffiths`\
`    8  Мирослав Николић`\
`    7  Luis de Bethencourt`\
`    5  Lubosz Sarnecki`\
`    5  Martin Srebotnjak`\
`    4  Rafael Ferreira`\
`    3  Aurimas Černius`\
`    3  Fran Diéguez`\
`    3  Milagros Infante Montero`\
`    2  Andrej Žnidaršič`\
`    2  Anton Belka`\
`    2  Balázs Úr`\
`    2  Bruno Brouard`\
`    2  Dimitris Spingos`\
`    2  Elad Alfassa`\
`    2  Joris Valette`\
`    2  Meenal-goyal`\
`    2  Pere Orga`\
`    2  Thiago Santos`\
`    1  Adonfo Jayme Barrientos`\
`    1  Antonio Fernandes C. Neto`\
`    1  Brian Grohe`\
`    1  Carles Ferrando`\
`    1  Christian Kirbach`\
`    1  Danny Piccirillo`\
`    1  Dominique Leuenberger`\
`    1  Enrico Nicoletto`\
`    1  Florêncio Neves`\
`    1  Gabor Kelemen`\
`    1  Gianvito Cavasoli`\
`    1  Jan Gerber`\
`    1  Javier Jardón`\
`    1  Jiro Matsuzawa`\
`    1  Jordi Mas`\
`    1  Marianne Corvellec`\
`    1  Mattias Põldaru`\
`    1  Milagros Alessandra Infante Montero`\
`    1  Odin Hørthe Omdal`\
`    1  Oliver Propst`\
`    1  Olivier Duchateau`\
`    1  Panagiotis Papadopoulos`\
`    1  Praveen Illa`\
`    1  Rūdolfs Mazurs`\
`    1  Simon Corsin`\
`    1  Simon Wenner`\
`    1  Ulisse Perusin`\
`    1  Yann Pravo`\
`    1  Yaron Shahrabani`\
`    1  Yuri Myasoedov`

In GES:

`  596  Thibault Saunier`\
`   98  Mathieu Duponchelle`\
`   74  Edward Hervey`\
`   54  Tim-Philipp Müller`\
`   34  Sebastian Dröge`\
`   26  Luis de Bethencourt`\
`   11  Simon Corsin`\
`   10  Volodymyr Rudyi`\
`    8  Stefan Kost`\
`    6  Mark Nauwelaerts`\
`    6  Stefan Sauer`\
`    5  Robert Swain`\
`    5  Vasilis Liaskovitis`\
`    5  Руслан Ижбулатов`\
`    4  Nicolas Dufresne`\
`    4  Thiago Santos`\
`    3  Alessandro Decina`\
`    3  Anton Belka`\
`    3  Lubosz Sarnecki`\
`    3  Paul Lange`\
`    3  Xabier Rodriguez Calvar`\
`    2  Matas Brazdeikis`\
`    2  Vincent Penquerc'h`\
`    1  Alban Browaeys`\
`    1  Andoni Morales Alastruey`\
`    1  David Schleef`\
`    1  Jean-François Fortin Tam`\
`    1  Joris Valette`\
`    1  Kerrick Staley`\
`    1  Kishore Arepalli`\
`    1  Mateu Batle`\
`    1  Stéphane Maniaci`\
`    1  Thomas Vander Stichele`\
`    1  Wim Taymans`

# Download, additional information and feedback

A tarball is available on
<http://ftp.gnome.org/pub/GNOME/sources/pitivi/0.91/>

See [the Pitivi website](http://www.pitivi.org) and [building with
GES](building_with_ges.md for download and installation
instructions.

Feedback is welcome. See [bug reporting](Bug_reporting.md) for
tips and tricks.
