#! /usr/bin/perl -w

use strict;
use warnings;

use CGI;

use Classes::User;

package main;

require 'Functions/config.pl';
require 'Functions/parser.pl';
require 'Functions/web.pl';
require 'Functions/encode.pl';
require 'Functions/FakeFunctions.pl';

our $CurUser = User->new()->auth();

our %conf = ();	# configuration directives
our $cgi = '';	# CGI data

LoadConfig();

print "Pragma: no-cache\n";
print "Expires: -1\n";
print "Cache-Control: no-cache\n";
print "Content-Type: text/html\n\n";

  # Import CGI parameters :
$cgi = CGI->new();

our $PageTitle = ' - Filter Help Page';
ParseComponent( 'CommonHeader' );
ParseComponent( 'Links' );

my $Node = $cgi->param( 'node' );
if ( $Node )
{
	ParseComponent( 'IDMEFHelp/Filter_Help_'.$Node );
}
else
{
	ParseComponent( 'IDMEFHelp/Filter_Help' );
}

ParseComponent( 'CommonFooter' );
