#! /usr/bin/perl -w

use strict;
use warnings;

use CGI;

use DBI;

use Classes::User;

package main;

require 'Functions/config.pl';
require 'Functions/db.pl';
require 'Functions/parser.pl';
require 'Functions/web.pl';
require 'Functions/encode.pl';
require 'Functions/packet.pl';
require 'Functions/FakeFunctions.pl';

our $CurUser = User->new()->auth();

our %conf = ();	# configuration directives
our $cgi = '';	# CGI data

LoadConfig();

print "Pragma: no-cache\n";
print "Expires: -1\n";
print "Cache-Control: no-cache\n";
print "Content-Type: text/html\n\n";

  # Open the DB connection :
our $dbh = DB_Open();

  # Import CGI parameters :
$cgi = CGI->new();

our $PageTitle = " - Alert's Details (Packet)";
ParseComponent( 'CommonHeader' );
ParseComponent( 'Links' );

our $AlertId = int( $cgi->param( 'id' ) );

print<<"EOF";
<a href="AlertDetails$conf{'extension'}?id=$AlertId">Standard</a> /
<a href="AlertDetails_XML$conf{'extension'}?id=$AlertId">XML</a> / 
Packet<br>
<br>
EOF

my $Style = $cgi->param( 'style' );
if ( ! defined( $Style ) ) {$Style = 'STD';};

my %Output;
my %Proto;

my @Results = get_Data( 'Alert/AdditionalData', $AlertId, 'ALL' );
foreach my $LineNum ( 1..$Results[0] )
{
	my %Res = get_DataLine( \@Results, $LineNum );

	if ( $Res{'meaning'} eq 'Ethernet header' )
	{
		$Proto{'2'} = 'ETH';
		$Output{'2'} = Packet_Ethernet( $Res{'data'}, $Style );
	}

	if ( $Res{'meaning'} eq 'Arp header' )
	{
		$Proto{'3'} = 'ARP';
		$Output{'3'} = Packet_ARP( $Res{'data'}, $Style );
	}

	if ( $Res{'meaning'} eq 'Ip header' )
	{
		$Proto{'3'} = 'IP';
		$Output{'3'} = Packet_IPv4( $Res{'data'}, $Style );
	}

	if ( $Res{'meaning'} eq 'Tcp header' )
	{
		$Proto{'4'} = 'TCP';
		$Output{'4'} = Packet_TCP( $Res{'data'}, $Style );
	}

	if ( $Res{'meaning'} eq 'Udp header' )
	{
		$Proto{'4'} = 'UDP';
		$Output{'4'} = Packet_UDP( $Res{'data'}, $Style );
	}

	if ( $Res{'meaning'} eq 'Icmp header' )
	{
		$Proto{'4'} = 'ICMP';
		$Output{'4'} = Packet_ICMP( $Res{'data'}, $Style );
	}

	if ( $Res{'meaning'} eq 'Payload Hexadecimal Dump' )
	{
		$Proto{'5'} = 'App';
		$Res{'data'} =~ s/</&lt;/g;
		$Res{'data'} =~ s/>/&gt;/g;
		$Output{'5'} = "<pre>$Res{'data'}</pre>";
	}
}

print "<table border=1>\n";
foreach my $Level ( 2..5 )
{
	if ( $Proto{$Level} )
	{
print<<"EOB";
  <tr>
    <td align=center>$Proto{$Level}</td>
    <td>$Output{$Level}</td>
  </tr>
EOB
	}
}
print "</table>\n";

ParseComponent( 'CommonFooter' );
