#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <limits.h>
#include <time.h>

#ifndef _POSIX_PATH_MAX
# include <posix1_lim.h>
#endif

#ifdef _MAIN_C
# define WHERE
# define INITVAL(x) = x
#else
# define WHERE extern
# define INITVAL(x)
#endif


struct pkspxy_strlist
{
  char *str;
  struct pkspxy_strlist *next;
};

struct pkspxy_conn
{
  unsigned char *buff;
  char *query;
  time_t t;
  time_t stamp;
  size_t bufflen;
  short state;
  int fd;
  struct pkspxy_conn *next;
};

#define CS_READREQ 	1
#define CS_UPDATE	2
#define CS_REPLY	3
#define CS_DONE		4

WHERE char *Progname INITVAL (0);
WHERE char *SpoolDir INITVAL (NULL);
WHERE int ForcePostponed INITVAL (0);
WHERE int Online INITVAL (1);
WHERE int Port INITVAL (11372);
WHERE int PostponedInterval INITVAL (600);
WHERE int RecheckInterval INITVAL (3600);
WHERE int Debug INITVAL (0);
WHERE int Signalled INITVAL (0);
WHERE struct pkspxy_conn *Connections INITVAL (NULL);
WHERE struct pkspxy_strlist *Keyservers INITVAL (NULL);
WHERE struct pkspxy_strlist *PostponedQueries INITVAL (NULL);
WHERE time_t LastPostponedTimestamp INITVAL (0);

int pkspxy_create_spool (void);
int pkspxy_is_postponed (const char *);
int pkspxy_parse_config (const char *);
int pkspxy_spawn_reply (const char *, time_t, int);
int pkspxy_spawn_request (const char *, unsigned int, struct pkspxy_conn *);
int pkspxy_update_cache (char *, size_t, const char *);

struct pkspxy_conn *pkspxy_find_conn (int);
struct pkspxy_conn *pkspxy_new_conn (void);

void pkspxy_add_child (pid_t, const char *, struct pkspxy_conn *);
void pkspxy_add_conn (int );
void pkspxy_collect_children (void);
void pkspxy_conn_add_data (struct pkspxy_conn *, const char *, size_t);
void pkspxy_dump_postponed (void);
void pkspxy_delete_conn (int );
void pkspxy_free_conn (struct pkspxy_conn **);
void pkspxy_handle_postponed_requests (short);
void pkspxy_init_config (void);
void pkspxy_notify_conn (struct pkspxy_conn *);
void pkspxy_postponed_append (const char *);
void pkspxy_restore_postponed (void);
void pkspxy_spool_file (char *, size_t, const char *);
void pkspxy_select_loop (void);

