#ifndef KCATEGORIZEDITEMSVIEWDELEGATE_H_
#define KCATEGORIZEDITEMSVIEWDELEGATE_H_

#include <QtCore>
#include <QtGui>
#include <KIcon>
#include "KCategorizedItemsViewModels.h"

class KCategorizedItemsView;

namespace KCategorizedItemsViewModels {
    class AbstractItem;
}

/**
 * Delegate for displaying the items
 */
class KCategorizedItemsViewDelegate: public QItemDelegate
{
    Q_OBJECT
    
public:
    KCategorizedItemsViewDelegate(QObject *parent = 0);
    
    void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const;
    QSize sizeHint ( const QStyleOptionViewItem & option, const QModelIndex & index ) const;
    int columnWidth (int column, int viewWidth) const;
        
    bool editorEvent(QEvent *event,
                     QAbstractItemModel *model,
                     const QStyleOptionViewItem &option,
                     const QModelIndex &index);

private:
    
    KCategorizedItemsView * m_parent;
    KIcon m_favoriteIcon;
    KIcon m_favoriteAddIcon;
    KIcon m_favoriteRemoveIcon;
    
    mutable KCategorizedItemsViewModels::AbstractItem * m_onFavoriteIconItem;
    
    
    KCategorizedItemsViewModels::AbstractItem * getItemByProxyIndex(const QModelIndex & index) const;
};

/**
 * Delegate for displaying the filters/categories
 */
class KCategorizedItemsViewFilterDelegate: public QItemDelegate
{
    Q_OBJECT
    
public:
    KCategorizedItemsViewFilterDelegate(QObject *parent = 0);
    
    void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const;
    QSize sizeHint ( const QStyleOptionViewItem & option, const QModelIndex & index ) const;
};

#endif /*KCATEGORIZEDITEMSVIEWDELEGATE_H_*/
