/***************************************************************************
 *   Copyright (C) 2005,2006,2007 by Siraj Razick                          *
 *   siraj@kdemail.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#ifndef RUBY_APPLET_FACTORY_H
#define RUBY_APPLET_FACTORY_H

#include <QString>
#include <QFileInfo>

#include <KStandardDirs>
#include <klibloader.h>

/*
    Duplication the definition of this struct, to avoid linking directly
    against the QtRuby libs
*/
struct smokeruby_object {
    bool allocated;
    void *smoke;
    int classId;
    void *ptr;
};

/*
    Create an instance of the KPluginFactory class in Ruby, and return a
    pointer to the underlying c++ instance.

    The Plasma runtime will subsequently call createObject() on the factory,
    which in turn calls the ruby KDE::LibFactory.createObject() method to
    construct the applet.
*/
KPluginFactory *
rb_plasma_applet_factory(const char * factory)
{
    VALUE factory_klass = rb_const_get(rb_cObject, rb_intern(factory));
    if (factory_klass == Qnil) {
        return 0;
    }

    VALUE factory_value = rb_funcall(factory_klass, rb_intern("new"), 0);
    if (factory_value == Qnil) {
        return 0;
    }

    smokeruby_object * o = 0;
    Data_Get_Struct(factory_value, smokeruby_object, o);
    return (KPluginFactory *) o->ptr;
}

extern "C" {

KDE_EXPORT KPluginFactory *
init_plasma_applet_ruby_clock() 
{
    int state = 0;
    QString path = KStandardDirs::locate("data", "plasma-script/clock.rb");

    if (path.isEmpty()) {
        printf("Script missing\n");
    }

    QFileInfo program(path);

    ruby_init();
    ruby_script("clock.rb");
    ruby_init_loadpath();
    rb_require("plasma_applet");

    ruby_incpush((const char *) program.path().toLatin1());
    rb_load_protect(rb_str_new2(program.filePath().toLatin1()), 0, &state);
    if (state != 0) {
        printf("Failed to load %s\n", (const char *) program.filePath().toLatin1());
    }

    KPluginFactory * result = 0;
    result = rb_plasma_applet_factory("ClockFactory");
    if (result == 0) {
        printf("Can't construct ruby KDE::PluginFactory\n");
    }

    return result;
} 

}

#endif
