
print('MouseArrow.js: Launched');

// Setup look
applet.svg = new PlasmaSvg( 'widgets/greenarrow', applet );
applet.svg.contentType = applet.svg.SingleImage;
applet.svg.resize( 100, 100 );

// Setup data source
applet.mouse = applet.getDataEngine('mouse');

applet.paintInterface = function(painter)
{
  var pos = applet.mouse.query('Position');
  var geom = applet.geometry();

  dx = geom.x() - pos.Position.x() + geom.width()/2;
  dy = geom.y() - pos.Position.y() + geom.height()/2;

  theta = Math.atan2( dy, dx );

  painter.translate(100,100)
  painter.rotate( 360/(2*Math.PI)*(theta-Math.PI/2) );
  painter.setRenderHint( painter.Antialiasing, true );
  applet.svg.paint( painter, -50,-50 );
}

// Hack, should do this properly
applet.timer = new QTimer(applet);
applet.timer.start(200);
applet.timer.timeout.connect( applet.update );
