/*
 *   Copyright 2007 Richard J. Moore <rich@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef SCRIPT_H
#define SCRIPT_H

#include <QScriptValue>

#include <plasma/applet.h>
#include <plasma/dataengine.h>

class QScriptEngine;
class QScriptContext;

class Script : public Plasma::Applet
{
    Q_OBJECT

public:
    Script( QObject *parent, const QVariantList &args );
    ~Script();

    void reportError();

    Q_INVOKABLE QSizeF contentSizeHint() const;

    // This is a work around for the fact that dataEngine() seems to be coming
    // out as a void*.
    Q_INVOKABLE QObject *getDataEngine( const QString &name ) const;

    void paintInterface(QPainter *painter, const QStyleOptionGraphicsItem *option, const QRect &contentsRect);

    Q_INVOKABLE QString findDataResource( const QString &filename );
    Q_INVOKABLE void debug( const QString &msg );
    Q_INVOKABLE void update( const QRectF & rect = QRectF() ) { Applet::update(rect); }

public slots:
    void updated( const QString &name, const Plasma::DataEngine::Data &data );
    void showConfigurationInterface();
    void configAccepted();

private:
    void setupObjects();

    //static QScriptValue dataEngine(QScriptContext *context, QScriptEngine *engine);
    static QScriptValue loadui(QScriptContext *context, QScriptEngine *engine);
    static QScriptValue newPlasmaSvg(QScriptContext *context, QScriptEngine *engine);
    static QScriptValue newPlasmaCheckBox(QScriptContext *context, QScriptEngine *engine);
    static QScriptValue newPlasmaRadioButton(QScriptContext *context, QScriptEngine *engine);

private:
    QScriptEngine *m_engine;
    QScriptValue m_self;
};

K_EXPORT_PLASMA_APPLET(script, Script)


#endif // SCRIPT_H

