/***************************************************************************
 *   Copyright (C) 2007 by Siraj Razick siraj@kde.org                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#ifndef WELCOMEAPPLET_H
#define WELCOMEAPPLET_H

#include <plasma/applet.h>
#include "wellcomeitem.h"

namespace Plasma
{
    class LineEdit;
    class Svg;
} // namespace Plasma
class LimitedLineEdit;

class WelcomeApplet : public Plasma::Applet
{
        Q_OBJECT
    public:
        WelcomeApplet(QObject *parent, const QVariantList &args);
        ~WelcomeApplet();

        QSizeF contentSizeHint() const;

        virtual QRectF boundingRect() const;
        void paintInterface(QPainter *painter, const QStyleOptionGraphicsItem *option, const QRect &contentsRect);

    public slots:
        void editUpdate(const QString& text);

    private:
        WellcomeItem * icon1;
        WellcomeItem * icon2;
        WellcomeItem * icon3;
        WellcomeItem * icon4;
};

K_EXPORT_PLASMA_APPLET(welcome, WelcomeApplet)

#endif
