/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <qpainter.h>
#include <QtGui/QPaintEvent>
#include "kbfxfancypopupitem.h"

KbfxFancyPopupItem::KbfxFancyPopupItem ( QWidget * parent , const char * name , Qt::WindowFlags l ) :QWidget ( parent,name,l )
{
	m_dataSource =0;
	m_normal = QPixmap ( KbfxPlasmaSkinManager::
	                     getThemePixmapPath ( KbfxPlasmaSkinManager::MENUITEM_NORMAL ) );

	m_hasMouse = false;
}

KbfxFancyPopupItem::~KbfxFancyPopupItem()
{}

void
KbfxFancyPopupItem::setData ( KbfxDataSource * data )
{
	if ( data == 0 )
		return ;

	m_dataSource = data;

}

void
KbfxFancyPopupItem::loadData()
{

	if ( m_dataSource == 0 )
		return;
}


void
KbfxFancyPopupItem::paintEvent ( QPaintEvent * pe )
{
	QPainter p;
	p.begin ( this );

	if ( m_hasMouse == true )
		p.drawPixmap ( pe->rect(),m_normal );

	p.end();

}
#include "kbfxfancypopupitem.moc"

