/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "kbfxplasmafadeitem.h"
#include <qpixmap.h>
#include "effect.h"

KbfxPlasmaFadeItem::KbfxPlasmaFadeItem ( Q3CanvasPixmapArray * a , Q3Canvas * canvas ) :
		Q3CanvasSprite ( a, canvas )
{
	setAnimated ( true );
	QPixmap *  _img = this->image ( 0 );
	m_bg = _img->convertToImage();
	m_timer = new QTimer ( this );
	connect ( m_timer,SIGNAL ( timeout() ),this,SLOT ( update() ) );
	//m_timer->start(18,false);
	m_bg = m_bg.convertDepth ( 32 );
	m_bg.setAlphaBuffer ( true );

	m_alpha = 100;
	setState ( true );

}



KbfxPlasmaFadeItem::~KbfxPlasmaFadeItem()
{}


void
KbfxPlasmaFadeItem::draw ( QPainter & pe )
{

	pe.drawImage ( QRect ( 0,0,m_bg.width(),m_bg.height() ), ( m_bg ) );

}

void
KbfxPlasmaFadeItem::update()
{
	advance ( 0 );
	setFrame ( 0 );
	move ( 0,0 );

	//blends (m_bg,m_alpha,255,false,true);
	m_alpha -= 1;
	if ( m_alpha == 0 )
	{
		this->hide();
		m_timer->stop();
		m_state = false;
	}
	canvas()->update();
}

#include "kbfxplasmafadeitem.moc"
