/***************************************************************************
 *   Copyright (C) 2009 by Kai Dombrowe <just89@gmx.de>                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/


/// Qt
#include <QtGui>

/// KDE
#include <KDebug>

/// own
#include "gameitem.h"
#include "gamemodel.h"


GameModel::GameModel( QObject *parent )
	: QAbstractItemModel( parent )
{

	parentItem = new GameItem( "", "", 0 );

}


GameModel::~GameModel()
{

	qDeleteAll( items );

}


QVariant GameModel::data( const QModelIndex &index, int role ) const
{

	if( !index.isValid() )
		return QVariant();

	GameItem *item = static_cast<GameItem*>( index.internalPointer() );
	return item->data( role );

}


Qt::ItemFlags GameModel::flags( const QModelIndex &index ) const
{

	if( !index.isValid() )
		return 0;

	return Qt::ItemIsEnabled | Qt::ItemIsSelectable;

}


QModelIndex GameModel::index( int row, int column, const QModelIndex &parent ) const
{

	if( !hasIndex( row, column, parent ) )
		return QModelIndex();

	GameItem *childItem = items.at( row );

	if( childItem )
		return createIndex( row, column, childItem );
	else
		return QModelIndex();

}


QModelIndex GameModel::parent( const QModelIndex &index ) const
{

	Q_UNUSED( index );
	return QModelIndex();

}


int GameModel::rowCount( const QModelIndex &parent ) const
{

	Q_UNUSED( parent );
	return items.count();
 
}


void GameModel::addGame( const QString& name, const QString& icon, const QString& cmd, const bool& startx )
{


	if( !name.isEmpty() )
	{
		kDebug() << "new Game >" << name << icon << cmd << startx;
		GameItem *item = new GameItem( name, icon, parentItem );
		item->setCmd( cmd );
		item->setStartx( startx );
		items << item;
		connect( item, SIGNAL( needUpdate() ), this, SLOT( qUpdate() ) );
		qUpdate();
	}

}


void GameModel::qUpdate()
{

	emit dataChanged( QModelIndex(), QModelIndex() );

}


QString GameModel::icon(  int row, int column, const QModelIndex &parent )
{

	if( !hasIndex( row, column, parent ) )
		return QString();

	GameItem *item = items.at( row );
	
	if( item )
		return item->icon();
	else
		return QString();

}


void GameModel::removeItem(  int row, int column, const QModelIndex &parent )
{

	if( !hasIndex( row, column, parent ) )
		return;

	GameItem *item = items.at( row );
	items.removeOne( item );
	delete item;
	qUpdate();

}


GameItem* GameModel::item(  int row, int column, const QModelIndex &parent )
{

	if( !hasIndex( row, column, parent ) )
		return NULL;

	return items.at( row );

}


void GameModel::insertItem( GameItem *item, const int& row )
{

	if( item )
		items.insert( row, item );

}


void GameModel::removeGame( GameItem *game )
{

	if( game )
	{
		items.removeOne( game );
		delete game;
	}

}



#include "gamemodel.moc"




