/***********************************************************************************
* Spell Check: Plasmoid for fast spell checking.
* Copyright (C) 2008 - 2009 Michal Dutkiewicz aka Emdek <emdeck@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#ifndef SPELLCHECK_HEADER
#define SPELLCHECK_HEADER

#include <QTextEdit>
#include <QToolButton>

#include <Plasma/Applet>
#include <Plasma/Dialog>
#include <Plasma/IconWidget>

#include <kcombobox.h>
#include <sonnet/speller.h>
#include <sonnet/highlighter.h>
#include <sonnet/backgroundchecker.h>
#include <sonnet/dictionarycombobox.h>
#include <sonnet/dialog.h>

class QTextEdit;

class SpellCheckTextEdit : public QTextEdit
{
    Q_OBJECT

    public:
        void setSpellChecker(Sonnet::BackgroundChecker *checker);

    public slots:
        void replaceWord(QAction *action);

    private:
        void contextMenuEvent(QContextMenuEvent *event);

       Sonnet::BackgroundChecker *m_checker;
};

class QSizeF;

class SpellCheck : public Plasma::Applet
{
    Q_OBJECT

    public:
        SpellCheck(QObject *parent, const QVariantList &args);
        ~SpellCheck();

        void init();

    public slots:
        void toggleDialog();
        void dialogResized();
        void copyToClipboard();
        void showCheckerDialog();
        void setLanguage(QString language);
        void highlightWord(const QString word, int start);
        void replaceWord(const QString oldWord, int start, const QString newWord);

    private:
        int m_selectionStart;
        QToolButton *m_spellingButton;
        QToolButton *m_copyButton;
        SpellCheckTextEdit *m_textEdit;
        Sonnet::DictionaryComboBox *m_dictionaryComboBox;
        Sonnet::Highlighter *m_highlighter;
        Sonnet::BackgroundChecker *m_checker;
        Sonnet::Dialog *m_checkerDialog;
        Plasma::IconWidget *m_icon;
        Plasma::Dialog *m_dialog;
};

K_EXPORT_PLASMA_APPLET(spellcheck, SpellCheck)
#endif
