/******************************************************************************
*                             plasma-am4rok                                   *
*******************************************************************************
*                                                                             *
*            Copyright (C) 2008 Giulio Camuffo				      *
*	     Copyright (C) 2008 John Varouhakis                               *
*                                                                             *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

/* 19/03/2008 , author Giulio Camuffo 
adapted file to work with amaroK 2*/

#ifndef AM4ROK_CLIENT_H
#define AM4ROK_CLIENT_H

#include <QColor>
#include <KConfigDialog>

#include <Plasma/Applet>

#include "player_controller.h"
#include "mminfowidget.h"
#include "ui_am4rokConfig.h"

class QGraphicsSceneWhellEvent;
class QGraphicsSceneMouseEvent;


class Am4rokClient : public Plasma::Applet{
    Q_OBJECT
    public:
        Am4rokClient(QObject *parent, const QVariantList &args);
        ~Am4rokClient();

        void init();
        void constraintsEvent(Plasma::Constraints);

	void hoverEnterEvent(QGraphicsSceneHoverEvent *);
	void hoverLeaveEvent(QGraphicsSceneHoverEvent *);
	void wheelEvent(QGraphicsSceneWheelEvent *event);
        QSizeF contentSizeHint();

    public slots:
	void changeProgressBarValue(const int &value);

    protected:
	void createConfigurationInterface(KConfigDialog *parent);

    protected slots:
        void configAccepted();

    private:
	bool isOnDesktop(void);
	void updateContentsGeometry(void);

	MMInfoWidget *infoWidget;
	PlayerController *controller;
	int m_width;
	int m_height;
	int t_width;
	int t_height;
	bool closeDialogOnFocusOut;
	bool showStrings;
	Ui::am4rokConfig ui;

};

K_EXPORT_PLASMA_APPLET(am4rok, Am4rokClient )
#endif

