/**
 *
 * @file     callbacks.h
 * @author   Aleix Conchillo Flaque <aleix@member.fsf.org>
 * @date     Tue Aug 05, 2005 21:56
 * @brief    Playground callbacks
 *
 * $Id$
 *
 * @if copyright
 *
 * Copyright (C) 2005 Aleix Conchillo Flaque
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * @endif
 */


#ifndef CALLBACKS_H_0508052156
#define CALLBACKS_H_0508052156

#include "playground.h"

#include <gtk/gtk.h>
#include <panel-applet.h>

/* General callbacks */

extern void cb_realize(GtkWidget *w, playground_t *pg);
extern void cb_destroy(GtkWidget *w, playground_t *pg);
extern void cb_change_size(GtkWidget *w, gint size, playground_t *pg);
extern void cb_change_orient(GtkWidget *w, PanelAppletOrient orient,
                             playground_t *pg);
extern void cb_style_set(GtkWidget *w, GtkStyle *style, playground_t *pg);

/* General interface callbacks */

extern gboolean cb_scrollwheel(GtkWidget *w, GdkEventScroll *event,
                               playground_t *pg);

/* Progress bar callbacks */

extern gboolean cb_seek(GtkWidget *w, GdkEventButton *event,
                        playground_t *pg);

/* Button callbacks */

extern gboolean cb_button_press(GtkWidget *w, GdkEventButton *event,
                                playground_t *pg);
extern void cb_prev_clicked(GtkWidget *w, playground_t *pg);
extern void cb_play_pause_clicked(GtkWidget *w, playground_t *pg);
extern void cb_stop_clicked(GtkWidget *w, playground_t *pg);
extern void cb_next_clicked(GtkWidget *w, playground_t *pg);
extern void cb_eject_clicked(GtkWidget *w, playground_t *pg);

/* Menu callbacks */

extern void cb_repeat_menu(BonoboUIComponent *uic, playground_t *pg,
                           gchar const *verb);
extern void cb_shuffle_menu(BonoboUIComponent *uic, playground_t *pg,
                            gchar const *verb);
extern void cb_toggle_repeat(BonoboUIComponent *uic, gchar const *path,
                             Bonobo_UIComponent_EventType type,
                             gchar const *state, playground_t *pg);
extern void cb_toggle_shuffle(BonoboUIComponent *uic, gchar const *path,
                              Bonobo_UIComponent_EventType type,
                              gchar const *state, playground_t *pg);
extern void cb_main_win_menu(BonoboUIComponent *uic, playground_t *pg,
                             gchar const *verb);
extern void cb_playlist_win_menu(BonoboUIComponent *uic, playground_t *pg,
                                 gchar const *verb);
extern void cb_show_hide_menu(BonoboUIComponent *uic, playground_t *pg,
                              gchar const *verb);
extern void cb_player_pref_menu(BonoboUIComponent *uic, playground_t *pg,
                                gchar const *verb);
extern void cb_pref_menu(BonoboUIComponent *uic, playground_t *pg,
                         gchar const *verb);
extern void cb_quit_menu(BonoboUIComponent *uic, playground_t *pg,
                         gchar const *verb);
extern void cb_about_menu(BonoboUIComponent *uic, gpointer *ignore,
                          gchar const *verb);

#endif /* CALLBACKS_H_0508052156 */
