/**
 *
 * @file     main.c
 * @brief    playground applet main file
 * @author   Aleix Conchillo Flaque <aleix@member.fsf.org>
 * @date     Sun Nov 20, 2005 14:57
 *
 * Copyright (C) 2005, 2006 Aleix Conchillo Flaque
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include <config.h>

#include "callbacks.h"
#include "interface.h"
#include "playground.h"
#include "player.h"
#include "preferences.h"

#include <string.h>

/* Static functions declaration */

static gboolean main_applet_factory (PanelApplet *panel_applet,
                                     const gchar *iid,
                                     gpointer data);
static gboolean main_applet_fill (PanelApplet *panel_applet);
static void main_applet_signals (GtkWidget *applet, gpointer pg);

PANEL_APPLET_BONOBO_FACTORY ("OAFIID:GNOME_PlaygroundApplet_Factory",
                             PANEL_TYPE_APPLET,
                             "playground_applet",
                             VERSION,
                             main_applet_factory,
                             NULL);

/* Static functions definition */

static gboolean
main_applet_factory (PanelApplet *panel_applet, const gchar *iid,
                     gpointer data)
{
  static char *applet_str = "OAFIID:GNOME_PlaygroundApplet";
  gboolean retval = FALSE;

  if (!strcmp (iid, applet_str))
    {
      panel_applet_set_flags (panel_applet, PANEL_APPLET_EXPAND_MINOR);
      retval = main_applet_fill (panel_applet);
    }

  return retval;
}

static gboolean
main_applet_fill (PanelApplet *panel_applet)
{
  GtkWidget *applet = GTK_WIDGET (panel_applet);

  playground_t *pg = playground_create ();
  pg_player_t *player = playground_player (pg);
  pg_gui_t *gui = playground_gui (pg);

  if (!preferences_init (player))
    {
      gui_show_error (_("Unable to load preferences dialog."));
      return FALSE;
    }

  gui_init (gui, applet, (gpointer) pg);

  main_applet_signals (applet, pg);

  return TRUE;
}

static void
main_applet_signals (GtkWidget *applet, gpointer pg)
{
  /* Main signals */
  g_signal_connect (applet, "destroy", G_CALLBACK (cb_destroy), pg);

  /* Rest of main signals (after GUI initialization) */
  g_signal_connect (applet, "change_size", G_CALLBACK(cb_change_size), pg);
  g_signal_connect (applet, "change_orient", G_CALLBACK(cb_change_orient), pg);
  g_signal_connect (applet, "style_set", G_CALLBACK(cb_style_set), pg);

  /* General interface signals */
  gtk_widget_add_events (applet, GDK_SCROLL_MASK);
  g_signal_connect (applet, "scroll_event", G_CALLBACK (cb_scrollwheel), pg);
}
