/**
 * @file     plugins.h
 * @brief    Playground plugins support
 * @author   Aleix Conchillo Flaque <aleix@member.fsf.org>
 * @date     Fri Sep 23, 2005 18:32
 *
 * Copyright (C) 2005, 2006 Aleix Conchillo Flaque
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef PLUGINS_H_0509231832
#define PLUGINS_H_0509231832

#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

  typedef struct
  {
    gchar *version;             /* Plugin version */
    gchar *pg_version;          /* Supported playground version */
    gchar *author;              /* Plugin's author */
    gchar *short_desc;          /* Short description */
    gchar *long_desc;           /* Long description */
    void (*plugin_init)(void);  /* Initialisation callback */
    void (*plugin_close)(void); /* Plugins close callback */
    gboolean (*player_start)(void); /* Starts/Executes player (true if ok) */
    void (*player_quit)(void);  /* Terminate player */
    void (*prev_song)(void);    /* Go to previous song */
    void (*play_pause)(void);   /* Play/Pause  */
    void (*stop)(void);         /* Stop playing */
    void (*next_song)(void);    /* Next song */
    void (*eject)(void);        /* Eject button */
    void (*seek)(gdouble t);    /* Seek to time (0.0 to 1.0) */
    void (*repeat)(gboolean enable); /* Toggle repetition mode */
    void (*shuffle)(gboolean enable); /* Toggle shuffle mode */
    void (*main_win)(gboolean enable); /* Show/Hide main player window */
    void (*playlist_win)(gboolean enable); /* Show/Hide play list window */
    void (*show_hide)(void);               /* Show/Hide all windows */
    void (*preferences)(void);             /* Show player preferences */
    void (*lower_volume)(void);            /* Low volume */
    void (*raise_volume)(void);            /* Raise volume */
    gint (*is_running)(void);              /* Is player running? */
    gint (*is_playing)(void);              /* Is player playing? */
    gint (*is_paused)(void);               /* Is player paused? */
    gint (*is_repeat)(void);               /* Is repeat mode activated? */
    gint (*is_shuffle)(void);              /* Is shuffle mode activated? */
    gint (*is_main_win)(void);             /* Is main window visible? */
    gint (*is_playlist_win)(void);         /* Is play list window visible? */
    gchar* (*track_name)(void);            /* Track's name */
    gchar* (*track_album)(void);           /* Track's album */
    gchar* (*track_artist)(void);          /* Track's artist */
    gdouble (*track_rating)(void);         /* Track's rating (0.0 to 1.0) */
    gint (*track_current_time)(void);      /* Track's current time (in ms) */
    gint (*track_total_time)(void);        /* Track's total time (in ms) */
  } pg_plugin_t;

  /**
   * This function should be provided by all playground plugins. It
   * returns a pointer to a pg_plugin_t structure which contains
   * the callbacks and the information about the plugin.
   */
  extern pg_plugin_t*
  playground_plugin_info (void);

#ifdef __cplusplus
}
#endif

#endif /* PLUGINS_H_0509231832 */
