; function telling if a value is in a list
(define in-list
  (lambda (l e)
    (if (null? l)
        #f
        (if (= (car l) e)
            #t
            (in-list (cdr l) e)
            )
        )
    )
  )

; function showing a set of layer, and hide the others
(define show-layers
  (lambda (img layers)
    (let ( (all_layers (gimp-image-get-layers img)) )
      (let loop ((i 0))
        (unless (= i (car all_layers))
                (let ( (layer_i (aref (cadr all_layers) i)) )
                  (if (in-list layers i)
                      (gimp-drawable-set-visible layer_i TRUE)
                      (gimp-drawable-set-visible layer_i FALSE))
                  (loop (+ i 1))
                  ) ; let
                ) ; unless
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define

; create the scaled frame of an animation
(define create-layer
  (lambda (img layers x y w h the_image)
    ; select the visible layers
    (show-layers img layers)
    (let ( (frame (car (begin
                         (gimp-edit-copy-visible img)
                         (gimp-edit-paste-as-new)
                         ) ; begin
                       ) ; car
                  ) ) ; frame
                                        ; create the resulting merged layer
      (let ( (the_layer (car
                         (gimp-layer-new-from-drawable
                          (car (gimp-image-get-active-drawable frame))
                          the_image
                          ) ; gimp-layer-new-from-drawable
                         ) ; car
                        ) ) ; the_layer
                                        ; resize the layer
        (gimp-image-add-layer the_image the_layer -1)
        (gimp-layer-scale the_layer w h TRUE)
        (gimp-layer-set-offsets the_layer x y)
        ) ; let
      ) ; let
    ) ; lambda
  ) ; define

; Save the resulting image then exit the Gimp
(define save-frames-and-exit
  (lambda (name img)
    (gimp-image-merge-visible-layers img 0)
    (gimp-file-save 1 img (car (gimp-image-get-active-drawable img)) name name)
    (gimp-quit 1)
    ) ; lambda
  ) ; define
